#version 150

in vec3 Position;
in vec2 UV0;

uniform sampler2D Sampler0;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec2 ScreenSize;
uniform float GameTime;

out vec2 texCoord0;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);
    texCoord0 = UV0;

    int h = int((ModelViewMat * vec4(1)).z);
    int corner = gl_VertexID % 4;
    vec2 texsize = textureSize(Sampler0, 0);
    float texratio = texsize.x / texsize.y;
    float ratio = ScreenSize.x / ScreenSize.y;

    if (h == -1999 && (texsize == vec2(1600,900))) { //main/option menu background
        texCoord0 = ((vec2(gl_Position.x,-gl_Position.y*0.88)+1)*0.5 - 0.5);
        texCoord0 *= ratio > texratio ? vec2(1, 2/ratio) : vec2(ratio * 0.5, 1);
        texCoord0 += 0.5;
    }
}