/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class BungeeAliases
extends Plugin
implements Listener {
    private List<Alias> aliases;
    private String connectingMessage;
    private String connectingNoPermission;
    private String alreadyConnectedMessage;

    public void onEnable() {
        this.loadConfig();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new Commands(this));
    }

    public void onDisable() {
        this.getProxy().getPluginManager().unregisterCommands((Plugin)this);
        this.getProxy().getPluginManager().unregisterListeners((Plugin)this);
    }

    public void loadConfig() {
        ConfigurationLoader configurationLoader = new ConfigurationLoader(this, "config.yml");
        this.aliases = new ArrayList<Alias>();
        try {
            this.connectingMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)configurationLoader.getConfiguration().getString("connectingMessage", "\u00a7aConnecting to %s server..."));
            this.connectingNoPermission = ChatColor.translateAlternateColorCodes((char)'&', (String)configurationLoader.getConfiguration().getString("connectingNoPermission", "\u00a7cYou do not have permission to connect to %s server."));
            this.alreadyConnectedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)configurationLoader.getConfiguration().getString("alreadyConnectedMessage", "\u00a7aYou're already connected to %s server."));
            for (String server : configurationLoader.getConfiguration().getSection("aliases").getKeys()) {
                for (String alias : configurationLoader.getConfiguration().getSection("aliases." + server).getKeys()) {
                    String permission = configurationLoader.getConfiguration().getString("aliases." + server + "." + alias + ".permission");
                    if (permission.equals("")) {
                        permission = null;
                    }
                    this.aliases.add(new Alias(server, alias, configurationLoader.getConfiguration().getBoolean("aliases." + server + "." + alias + ".forward"), permission));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=65)
    public void onChatEvent(ChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (Alias alias : this.aliases) {
            if (!alias.alias.equalsIgnoreCase(event.getMessage())) continue;
            ProxyServer proxyServer = this.getProxy();
            ServerInfo serverInfo = proxyServer.getServerInfo(alias.server);
            if (serverInfo == null) {
                return;
            }
            ProxiedPlayer proxiedPlayer = (ProxiedPlayer)event.getSender();
            if (alias.permission != null && !proxiedPlayer.hasPermission(alias.permission)) {
                if (!this.connectingNoPermission.equals("")) {
                    proxiedPlayer.sendMessage((BaseComponent)new TextComponent(String.format(this.connectingNoPermission, alias.server)));
                }
                if (alias.forward) continue;
                event.setCancelled(true);
                continue;
            }
            if (alias.server.equalsIgnoreCase(proxiedPlayer.getServer().getInfo().getName())) {
                if (!this.alreadyConnectedMessage.equals("")) {
                    proxiedPlayer.sendMessage((BaseComponent)new TextComponent(String.format(this.alreadyConnectedMessage, alias.server)));
                }
                if (alias.forward) continue;
                event.setCancelled(true);
                continue;
            }
            if (!this.connectingMessage.equals("")) {
                proxiedPlayer.sendMessage((BaseComponent)new TextComponent(String.format(this.connectingMessage, alias.server)));
            }
            if (!event.isCancelled()) {
                event.setCancelled(true);
            }
            proxiedPlayer.connect(serverInfo);
        }
    }
}

