/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ConfigurationLoader {
    private Configuration configuration;

    public ConfigurationLoader(Plugin plugin, String filename) {
        try {
            File file;
            if (!plugin.getDataFolder().exists()) {
                plugin.getLogger().info("Creating configuration folder - first run?");
                plugin.getDataFolder().mkdir();
            }
            if (!(file = new File(plugin.getDataFolder(), filename)).exists()) {
                plugin.getLogger().info("Creating default configuration file - first run?");
                Files.copy(plugin.getResourceAsStream("config.yml"), file.toPath(), new CopyOption[0]);
            }
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

