/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import ru.leymooo.botfilter.BotFilter;
import ru.leymooo.botfilter.config.Settings;

public class ServerPingUtils {
    private Cache<InetAddress, Boolean> pingList;
    private boolean enabled;
    private final BotFilter botFilter;

    public ServerPingUtils(BotFilter botFilter) {
        this.enabled = Settings.IMP.SERVER_PING_CHECK.MODE != 2;
        this.botFilter = botFilter;
        this.pingList = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(100).expireAfterWrite(Settings.IMP.SERVER_PING_CHECK.CACHE_TIME, TimeUnit.SECONDS).build();
    }

    public boolean needKickOrRemove(InetAddress address) {
        boolean present;
        boolean bl = present = this.pingList.getIfPresent(address) == null;
        if (!present) {
            this.pingList.invalidate(address);
        }
        return present;
    }

    public void add(InetAddress address) {
        if (this.enabled) {
            this.pingList.put(address, true);
        }
    }

    public boolean needCheck() {
        return this.enabled && (Settings.IMP.SERVER_PING_CHECK.MODE == 0 || this.botFilter.isUnderAttack());
    }

    public void clear() {
        this.pingList.invalidateAll();
    }

    public void cleanUP() {
        this.pingList.cleanUp();
    }
}

