/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.utils;

import com.google.common.collect.Queues;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Queue;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.config.Settings;

public final class FailedUtils {
    private static final Path out = Paths.get("BotFilter", "failed.txt");
    private static final Queue<String> writeQueue = Queues.newConcurrentLinkedQueue();

    public static void addIpToQueue(String ip, PacketUtils.KickType reason) {
        if (Settings.IMP.SAVE_FAILED_IPS_TO_FILE && reason != PacketUtils.KickType.COUNTRY) {
            writeQueue.add(ip + "|" + reason.name() + "|" + System.currentTimeMillis());
        }
    }

    public static void flushQueue() {
        Queue<String> queue = writeQueue;
        int j = queue.size();
        if (j == 0) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(out, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            String line;
            while (j-- > 0 && (line = queue.poll()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            BungeeCord.getInstance().getLogger().log(Level.WARNING, "[BotFilter] Could not save failed ips to file", e);
        }
    }

    private FailedUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

