/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EmptyChunkPacket
extends DefinedPacket {
    int x;
    int z;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int version) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        buf.writeBoolean(true);
        if (version >= 735 && version < 751) {
            buf.writeBoolean(true);
        }
        if (version == 47) {
            buf.writeShort(1);
        } else {
            EmptyChunkPacket.writeVarInt(0, buf);
        }
        if (version >= 477) {
            this.write1_14Heightmaps(buf);
            if (version >= 573) {
                if (version >= 751) {
                    EmptyChunkPacket.writeVarInt(1024, buf);
                    for (int i = 0; i < 1024; ++i) {
                        EmptyChunkPacket.writeVarInt(1, buf);
                    }
                } else {
                    for (int i = 0; i < 1024; ++i) {
                        buf.writeInt(0);
                    }
                }
            }
        }
        if (version < 393) {
            EmptyChunkPacket.writeArray(new byte[256], buf);
        } else if (version == 393) {
            EmptyChunkPacket.writeArray(new byte[512], buf);
        } else {
            EmptyChunkPacket.writeArray(new byte[1024], buf);
        }
        if (version >= 110) {
            DefinedPacket.writeVarInt(0, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
    }

    private void write1_14Heightmaps(ByteBuf buf) {
        try (ByteBufOutputStream output = new ByteBufOutputStream(buf);){
            output.writeByte(10);
            output.writeUTF("");
            output.writeByte(10);
            output.writeUTF("root");
            output.writeByte(12);
            output.writeUTF("MOTION_BLOCKING");
            long[] longArrayTag = new long[36];
            output.writeInt(longArrayTag.length);
            int length = longArrayTag.length;
            for (int i = 0; i < length; ++i) {
                output.writeLong(longArrayTag[i]);
            }
            buf.writeByte(0);
            buf.writeByte(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public String toString() {
        return "EmptyChunkPacket(x=" + this.getX() + ", z=" + this.getZ() + ")";
    }

    public EmptyChunkPacket() {
    }

    public EmptyChunkPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmptyChunkPacket)) {
            return false;
        }
        EmptyChunkPacket other = (EmptyChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmptyChunkPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        return result;
    }
}

