/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.caching;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PluginMessage;
import ru.leymooo.botfilter.caching.CachedCaptcha;
import ru.leymooo.botfilter.caching.CachedExpPackets;
import ru.leymooo.botfilter.caching.CachedPacket;
import ru.leymooo.botfilter.caching.CachedTitle;
import ru.leymooo.botfilter.caching.PacketsPosition;
import ru.leymooo.botfilter.config.Settings;
import ru.leymooo.botfilter.packets.EmptyChunkPacket;
import ru.leymooo.botfilter.packets.JoinGame;
import ru.leymooo.botfilter.packets.PlayerAbilities;
import ru.leymooo.botfilter.packets.PlayerPositionAndLook;
import ru.leymooo.botfilter.packets.SetExp;
import ru.leymooo.botfilter.packets.SetSlot;
import ru.leymooo.botfilter.packets.TimeUpdate;

public class PacketUtils {
    public static final CachedCaptcha captchas = new CachedCaptcha();
    private static final CachedPacket[] cachedPackets = new CachedPacket[16];
    private static final HashMap<KickType, CachedPacket> kickMessagesGame = new HashMap(3);
    private static final HashMap<KickType, CachedPacket> kickMessagesLogin = new HashMap(4);
    public static int PROTOCOLS_COUNT = ProtocolConstants.SUPPORTED_VERSION_IDS.size();
    public static int CLIENTID = new Random().nextInt(2147483547) + 50;
    public static int KEEPALIVE_ID = 9876;
    public static CachedExpPackets expPackets;
    public static CachedTitle[] titles;

    public static ByteBuf createPacket(DefinedPacket packet, int id, int protocol) {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
        DefinedPacket.writeVarInt(id, buffer);
        packet.write(buffer, ProtocolConstants.Direction.TO_CLIENT, protocol);
        return buffer;
    }

    public static void init() {
        if (expPackets != null) {
            expPackets.release();
        }
        for (CachedPacket packet : cachedPackets) {
            if (packet == null) continue;
            packet.release();
        }
        for (CachedTitle title : titles) {
            if (title == null) continue;
            title.release();
        }
        for (CachedPacket packet : kickMessagesGame.values()) {
            packet.release();
        }
        kickMessagesGame.clear();
        expPackets = new CachedExpPackets();
        PacketUtils.titles[0] = new CachedTitle(Settings.IMP.MESSAGES.CHECKING_TITLE, 5, 90, 15);
        PacketUtils.titles[1] = new CachedTitle(Settings.IMP.MESSAGES.CHECKING_TITLE_CAPTCHA, 5, 15, 10);
        PacketUtils.titles[2] = new CachedTitle(Settings.IMP.MESSAGES.CHECKING_TITLE_SUS, 5, 20, 10);
        DefinedPacket[] packets = new DefinedPacket[]{new JoinGame(CLIENTID), new EmptyChunkPacket(0, 0), new TimeUpdate(1L, 23700L), new PlayerAbilities(6, 0.0f, 0.0f), new PlayerPositionAndLook(7.0, 450.0, 7.0, 90.0f, 38.0f, 9876, false), new SetSlot(0, 36, 358, 1, 0), new SetSlot(0, 36, -1, 0, 0), new KeepAlive(KEEPALIVE_ID), PacketUtils.createMessagePacket(Settings.IMP.MESSAGES.CHECKING_CAPTCHA_WRONG.replaceFirst("%s", "2").replaceFirst("%s", "\u043f\u043e\u043f\u044b\u0442\u043a\u0438")), PacketUtils.createMessagePacket(Settings.IMP.MESSAGES.CHECKING_CAPTCHA_WRONG.replaceFirst("%s", "1").replaceFirst("%s", "\u043f\u043e\u043f\u044b\u0442\u043a\u0430")), PacketUtils.createMessagePacket(Settings.IMP.MESSAGES.CHECKING), PacketUtils.createMessagePacket(Settings.IMP.MESSAGES.CHECKING_CAPTCHA), PacketUtils.createMessagePacket(Settings.IMP.MESSAGES.SUCCESSFULLY), new PlayerPositionAndLook(7.0, 450.0, 7.0, 90.0f, 10.0f, 9876, false), new SetExp(0.0f, 0, 0), PacketUtils.createPluginMessage()};
        for (int i = 0; i < packets.length; ++i) {
            PacketUtils.cachedPackets[i] = new CachedPacket(packets[i], Protocol.BotFilter, Protocol.GAME);
        }
        Protocol kickGame = Protocol.GAME;
        Protocol kickLogin = Protocol.LOGIN;
        CachedPacket failedMessage = new CachedPacket(PacketUtils.createKickPacket(Settings.IMP.MESSAGES.KICK_NOT_PLAYER), kickGame);
        kickMessagesGame.put(KickType.PING, new CachedPacket(PacketUtils.createKickPacket(Settings.IMP.MESSAGES.KICK_BIG_PING), kickGame));
        kickMessagesGame.put(KickType.FAILED_CAPTCHA, failedMessage);
        kickMessagesGame.put(KickType.FAILED_FALLING, failedMessage);
        kickMessagesGame.put(KickType.TIMED_OUT, failedMessage);
        kickMessagesGame.put(KickType.COUNTRY, new CachedPacket(PacketUtils.createKickPacket(Settings.IMP.MESSAGES.KICK_COUNTRY), kickGame));
        kickMessagesGame.put(KickType.BIG_PACKET, new CachedPacket(PacketUtils.createKickPacket("\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043d\u0430 \u0431\u043e\u0442\u0430. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043e\u0431 \u044d\u0442\u043e\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438. (\u0411\u044b\u043b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u043f\u0430\u043a\u0435\u0442)"), kickGame));
        kickMessagesLogin.put(KickType.PING, new CachedPacket(PacketUtils.createKickPacket(String.join((CharSequence)"", Settings.IMP.SERVER_PING_CHECK.KICK_MESSAGE)), kickLogin));
        kickMessagesLogin.put(KickType.MANYCHECKS, new CachedPacket(PacketUtils.createKickPacket(Settings.IMP.MESSAGES.KICK_MANY_CHECKS), kickLogin));
        kickMessagesLogin.put(KickType.COUNTRY, new CachedPacket(PacketUtils.createKickPacket(Settings.IMP.MESSAGES.KICK_COUNTRY), kickLogin));
    }

    private static DefinedPacket createKickPacket(String message) {
        return new Kick(ComponentSerializer.toString(TextComponent.fromLegacyText(ChatColor.translateAlternateColorCodes('&', message.replace("%prefix%", Settings.IMP.MESSAGES.PREFIX).replace("%nl%", "\n")))));
    }

    private static DefinedPacket createMessagePacket(String message) {
        if (message.isEmpty()) {
            return null;
        }
        return new Chat(ComponentSerializer.toString(TextComponent.fromLegacyText(ChatColor.translateAlternateColorCodes('&', message.replace("%prefix%", Settings.IMP.MESSAGES.PREFIX).replace("%nl%", "\n")))), (byte)ChatMessageType.CHAT.ordinal());
    }

    private static DefinedPacket createPluginMessage() {
        ByteBuf brand = ByteBufAllocator.DEFAULT.heapBuffer();
        DefinedPacket.writeString("BotFilter (https://vk.cc/8hr1pU)", brand);
        PluginMessage packet = new PluginMessage("MC|Brand", DefinedPacket.toArray(brand), false);
        brand.release();
        return packet;
    }

    public static int getPacketId(DefinedPacket packet, int version, Protocol ... protocols) {
        for (Protocol protocol : protocols) {
            try {
                return protocol.TO_CLIENT.getId(packet.getClass(), version);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Can not get id for " + packet.getClass().getSimpleName() + "(" + version + ")");
    }

    public static void releaseByteBuf(ByteBuf buf) {
        if (buf != null && buf.refCnt() != 0) {
            while (buf.refCnt() != 0) {
                buf.release();
            }
        }
    }

    public static void fillArray(ByteBuf[] buffer, DefinedPacket packet, Protocol ... protocols) {
        if (packet == null) {
            return;
        }
        int oldPacketId = -1;
        ByteBuf oldBuf = null;
        for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS) {
            int versionRewrited = PacketUtils.rewriteVersion(version);
            int newPacketId = PacketUtils.getPacketId(packet, version, protocols);
            if (newPacketId != oldPacketId) {
                oldPacketId = newPacketId;
                buffer[versionRewrited] = oldBuf = PacketUtils.createPacket(packet, oldPacketId, version);
                continue;
            }
            ByteBuf newBuf = PacketUtils.createPacket(packet, oldPacketId, version);
            if (newBuf.equals(oldBuf)) {
                buffer[versionRewrited] = oldBuf;
                newBuf.release();
                continue;
            }
            buffer[versionRewrited] = oldBuf = newBuf;
        }
    }

    public static int rewriteVersion(int version) {
        switch (version) {
            case 47: {
                return 0;
            }
            case 107: {
                return 1;
            }
            case 108: {
                return 2;
            }
            case 109: {
                return 3;
            }
            case 110: {
                return 4;
            }
            case 210: {
                return 5;
            }
            case 315: {
                return 6;
            }
            case 316: {
                return 7;
            }
            case 335: {
                return 8;
            }
            case 338: {
                return 9;
            }
            case 340: {
                return 10;
            }
            case 393: {
                return 11;
            }
            case 401: {
                return 12;
            }
            case 404: {
                return 13;
            }
            case 477: {
                return 14;
            }
            case 480: {
                return 15;
            }
            case 485: {
                return 16;
            }
            case 490: {
                return 17;
            }
            case 498: {
                return 18;
            }
            case 573: {
                return 19;
            }
            case 575: {
                return 20;
            }
            case 578: {
                return 21;
            }
            case 735: {
                return 22;
            }
            case 736: {
                return 23;
            }
            case 751: {
                return 24;
            }
            case 753: {
                return 25;
            }
            case 754: {
                return 26;
            }
        }
        throw new IllegalArgumentException("Version is not supported");
    }

    public static void spawnPlayer(Channel channel, int version, boolean disableFall, boolean captcha) {
        channel.write(PacketUtils.getCachedPacket(PacketsPosition.LOGIN).get(version), channel.voidPromise());
        channel.write(PacketUtils.getCachedPacket(PacketsPosition.PLUGIN_MESSAGE).get(version), channel.voidPromise());
        channel.write(PacketUtils.getCachedPacket(PacketsPosition.CHUNK).get(version), channel.voidPromise());
        if (disableFall) {
            channel.write(PacketUtils.getCachedPacket(PacketsPosition.PLAYERABILITIES).get(version), channel.voidPromise());
        }
        if (captcha) {
            channel.write(PacketUtils.getCachedPacket(PacketsPosition.PLAYERPOSANDLOOK_CAPTCHA).get(version), channel.voidPromise());
        } else {
            channel.write(PacketUtils.getCachedPacket(PacketsPosition.PLAYERPOSANDLOOK).get(version), channel.voidPromise());
        }
        channel.write(PacketUtils.getCachedPacket(PacketsPosition.TIME).get(version), channel.voidPromise());
    }

    public static void kickPlayer(KickType kick, Protocol protocol, ChannelWrapper wrapper, int version) {
        if (!wrapper.getHandle().isActive() || wrapper.isClosed() || wrapper.isClosing()) {
            return;
        }
        if (protocol == Protocol.GAME) {
            wrapper.close(kickMessagesGame.get((Object)kick).get(version));
        } else {
            wrapper.close(kickMessagesLogin.get((Object)kick).get(version));
        }
    }

    public static CachedPacket getCachedPacket(int pos) {
        return cachedPackets[pos];
    }

    static {
        titles = new CachedTitle[3];
    }

    public static enum KickType {
        MANYCHECKS,
        FAILED_CAPTCHA,
        FAILED_FALLING,
        TIMED_OUT,
        COUNTRY,
        LEAVED,
        BIG_PACKET,
        PING;

    }
}

