/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import ru.leymooo.botfilter.BotFilterThread;
import ru.leymooo.botfilter.BotFilterUser;
import ru.leymooo.botfilter.Connector;
import ru.leymooo.botfilter.caching.CachedCaptcha;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.captcha.CaptchaGeneration;
import ru.leymooo.botfilter.config.Settings;
import ru.leymooo.botfilter.utils.GeoIp;
import ru.leymooo.botfilter.utils.ManyChecksUtils;
import ru.leymooo.botfilter.utils.ServerPingUtils;
import ru.leymooo.botfilter.utils.Sql;

public class BotFilter {
    public static final long ONE_MIN = 60000L;
    private final Map<String, Connector> connectedUsersSet = new ConcurrentHashMap<String, Connector>();
    private final Map<String, BotFilterUser> userCache = new ConcurrentHashMap<String, BotFilterUser>();
    private final ExecutorService executor;
    private final Sql sql;
    private final GeoIp geoIp;
    private final ServerPingUtils serverPingUtils;
    private final CheckState normalState;
    private final CheckState attackState;
    private int botCounter = 0;
    private long lastAttack = 0L;
    private long lastCheck = System.currentTimeMillis();
    private boolean forceProtectionEnabled = false;

    public BotFilter(boolean startup) {
        Settings.IMP.reload(new File("BotFilter", "config.yml"));
        DefinedPacket.fix_scoreboards = Settings.IMP.FIX_SCOREBOARDS;
        Scoreboard.DISABLE_DUBLICATE = Settings.IMP.FIX_SCOREBOARD_TEAMS;
        this.checkForUpdates(startup);
        if (!CachedCaptcha.generated) {
            CaptchaGeneration.generateImages();
        }
        this.normalState = this.getCheckState(Settings.IMP.PROTECTION.NORMAL);
        this.attackState = this.getCheckState(Settings.IMP.PROTECTION.ON_ATTACK);
        PacketUtils.init();
        this.sql = new Sql(this);
        this.geoIp = new GeoIp(startup);
        this.serverPingUtils = new ServerPingUtils(this);
        this.executor = this.geoIp.isAvailable() ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactoryBuilder().setNameFormat("BF-%d").build()) : null;
        BotFilterThread.start();
    }

    public void disable() {
        BotFilterThread.stop();
        for (Connector connector : this.connectedUsersSet.values()) {
            if (connector.getUserConnection() != null) {
                connector.getUserConnection().disconnect("\u00a7c[BotFilter] \u00a7a\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0438\u043b\u044c\u0442\u0440\u0430");
            }
            connector.setState(CheckState.FAILED);
        }
        this.connectedUsersSet.clear();
        this.geoIp.close();
        this.sql.close();
        ManyChecksUtils.clear();
        this.serverPingUtils.clear();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void saveUser(String userName, InetAddress address, boolean afterCheck) {
        userName = userName.toLowerCase();
        long timestamp = System.currentTimeMillis();
        BotFilterUser botFilterUser = this.userCache.get(userName);
        if (botFilterUser == null) {
            botFilterUser = new BotFilterUser(userName, address.getHostAddress(), timestamp, timestamp);
        } else {
            botFilterUser.setIp(address.getHostAddress());
            botFilterUser.setLastJoin(timestamp);
            if (afterCheck) {
                botFilterUser.setLastCheck(timestamp);
            }
        }
        this.userCache.put(userName, botFilterUser);
        if (this.sql != null) {
            this.sql.saveUser(botFilterUser);
        }
    }

    public void addUserToCache(BotFilterUser botFilterUser) {
        this.userCache.put(botFilterUser.getName(), botFilterUser);
    }

    public void removeUser(String userName) {
        userName = userName.toLowerCase();
        this.userCache.remove(userName);
    }

    public void connectToBotFilter(UserConnection userConnection) {
        userConnection.getCh().setEncoderProtocol(Protocol.GAME);
        userConnection.getCh().setDecoderProtocol(Protocol.BotFilter);
        Connector connector = new Connector(userConnection, this);
        if (!this.addConnection(connector)) {
            userConnection.disconnect(BungeeCord.getInstance().getTranslation("already_connected_proxy", new Object[0]));
        } else {
            PacketDecompressor packetDecompressor = userConnection.getCh().getHandle().pipeline().get(PacketDecompressor.class);
            if (packetDecompressor != null) {
                packetDecompressor.checking = true;
            }
            userConnection.getCh().getHandle().pipeline().get(HandlerBoss.class).setHandler(connector);
            connector.spawn();
        }
    }

    public boolean addConnection(Connector connector) {
        return this.connectedUsersSet.putIfAbsent(connector.getName(), connector) == null;
    }

    public void removeConnection(String name, Connector connector) {
        Object object = name == null ? (connector == null ? null : connector.getName()) : (name = name);
        if (name == null) {
            throw new RuntimeException("Name and connector is null");
        }
        this.connectedUsersSet.remove(name);
    }

    public void incrementBotCounter() {
        ++this.botCounter;
    }

    public int getOnlineOnFilter() {
        return this.connectedUsersSet.size();
    }

    public int getUsersCount() {
        return this.userCache.size();
    }

    public boolean needCheck(String userName, InetAddress address) {
        BotFilterUser botFilterUser = this.userCache.get(userName.toLowerCase());
        return botFilterUser == null || Settings.IMP.FORCE_CHECK_ON_ATTACK && this.isUnderAttack() || !botFilterUser.getIp().equalsIgnoreCase(address.getHostAddress());
    }

    public boolean isOnChecking(String name) {
        return this.connectedUsersSet.containsKey(name.toLowerCase());
    }

    public boolean isUnderAttack() {
        if (this.isForceProtectionEnabled()) {
            return true;
        }
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastAttack < (long)Settings.IMP.PROTECTION_TIME) {
            return true;
        }
        long diff = currTime - this.lastCheck;
        if (diff <= 60000L && this.botCounter >= Settings.IMP.PROTECTION_THRESHOLD) {
            this.lastAttack = System.currentTimeMillis();
            this.lastCheck -= 61000L;
            return true;
        }
        if (diff >= 60000L) {
            this.botCounter = 0;
            this.lastCheck = System.currentTimeMillis();
        }
        return false;
    }

    public boolean checkBigPing(double ping) {
        int mode = this.isUnderAttack() ? 1 : 0;
        return ping != -1.0 && Settings.IMP.PING_CHECK.MODE != 2 && (Settings.IMP.PING_CHECK.MODE == 0 || Settings.IMP.PING_CHECK.MODE == mode) && ping >= (double)Settings.IMP.PING_CHECK.MAX_PING;
    }

    public boolean isGeoIpEnabled() {
        int mode = this.isUnderAttack() ? 1 : 0;
        return this.geoIp.isAvailable() && (Settings.IMP.GEO_IP.MODE == 0 || Settings.IMP.GEO_IP.MODE == mode);
    }

    public boolean checkGeoIp(InetAddress address) {
        return !this.geoIp.isAllowed(address);
    }

    public void checkAsyncIfNeeded(InitialHandler handler) {
        InetAddress address = handler.getAddress().getAddress();
        ChannelWrapper ch = handler.getCh();
        int version = handler.getVersion();
        BungeeCord bungee = BungeeCord.getInstance();
        if (!Settings.IMP.PROTECTION.ALWAYS_CHECK && ManyChecksUtils.isManyChecks(address)) {
            PacketUtils.kickPlayer(PacketUtils.KickType.MANYCHECKS, Protocol.LOGIN, ch, version);
            bungee.getLogger().log(Level.INFO, "(BF) [{0}] disconnected: Too many checks in 10 min", address);
            return;
        }
        ServerPingUtils ping = this.getServerPingUtils();
        if (ping.needCheck() && ping.needKickOrRemove(address)) {
            PacketUtils.kickPlayer(PacketUtils.KickType.PING, Protocol.LOGIN, ch, version);
            bungee.getLogger().log(Level.INFO, "(BF) [{0}] disconnected: The player did not ping the server", address.getHostAddress());
            return;
        }
        if (this.isGeoIpEnabled()) {
            this.executor.execute(() -> {
                if (this.checkGeoIp(address)) {
                    PacketUtils.kickPlayer(PacketUtils.KickType.COUNTRY, Protocol.LOGIN, ch, version);
                    bungee.getLogger().log(Level.INFO, "(BF) [{0}] disconnected: Country is not allowed", address.getHostAddress());
                    return;
                }
                handler.delayedHandleOfLoginRequset();
            });
        } else {
            handler.delayedHandleOfLoginRequset();
        }
    }

    public CheckState getCurrentCheckState() {
        return this.isUnderAttack() ? this.attackState : this.normalState;
    }

    private CheckState getCheckState(int mode) {
        switch (mode) {
            case 0: {
                return CheckState.ONLY_CAPTCHA;
            }
            case 1: {
                return CheckState.CAPTCHA_POSITION;
            }
            case 2: {
                return CheckState.CAPTCHA_ON_POSITION_FAILED;
            }
        }
        return CheckState.CAPTCHA_ON_POSITION_FAILED;
    }

    private void checkForUpdates(boolean startup) {
        Logger logger = BungeeCord.getInstance().getLogger();
        try {
            logger.log(Level.INFO, "[BotFilter] \u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u043d\u0430\u043b\u0438\u0447\u0435\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439");
            URL url = new URL("https://raw.githubusercontent.com/Leymooo/BungeeCord/master/version.txt");
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(1200);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                if (!in.readLine().trim().equalsIgnoreCase(Settings.IMP.BOT_FILTER_VERSION)) {
                    logger.log(Level.INFO, "\u00a7c[BotFilter] \u00a7a\u041d\u0430\u0439\u0434\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f!");
                    logger.log(Level.INFO, "\u00a7c[BotFilter] \u00a7a\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435\u0441\u044c!");
                    logger.log(Level.INFO, "\u00a7c[BotFilter] \u00a7ahttp://rubukkit.org/threads/137038");
                    if (startup) {
                        Thread.sleep(3500L);
                    }
                } else {
                    logger.log(Level.INFO, "[BotFilter] \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e!");
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.WARNING, "[BotFilter] \u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", ex);
        }
    }

    public Map<String, Connector> getConnectedUsersSet() {
        return this.connectedUsersSet;
    }

    public Map<String, BotFilterUser> getUserCache() {
        return this.userCache;
    }

    public Sql getSql() {
        return this.sql;
    }

    public GeoIp getGeoIp() {
        return this.geoIp;
    }

    public ServerPingUtils getServerPingUtils() {
        return this.serverPingUtils;
    }

    public void setLastCheck(long lastCheck) {
        this.lastCheck = lastCheck;
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public void setForceProtectionEnabled(boolean forceProtectionEnabled) {
        this.forceProtectionEnabled = forceProtectionEnabled;
    }

    public boolean isForceProtectionEnabled() {
        return this.forceProtectionEnabled;
    }

    public static enum CheckState {
        ONLY_POSITION,
        ONLY_CAPTCHA,
        CAPTCHA_POSITION,
        CAPTCHA_ON_POSITION_FAILED,
        SUCCESSFULLY,
        FAILED;

    }
}

