/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.protocol.DefinedPacket;
import ru.leymooo.botfilter.utils.FastBadPacketException;

public class PacketDecompressor
extends MessageToMessageDecoder<ByteBuf> {
    private static final int MAXIMUM_UNCOMPRESSED_SIZE = Integer.getInteger("maximumPacketSize", 2) * 1024 * 1024;
    private static final int MAXIMUM_UNCOMPRESSED_SIZE_WHILE_CHECKING = 65544;
    private int threshold = -1;
    public boolean checking = false;
    private BungeeZlib zlib;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.zlib = CompressFactory.zlib.newInstance();
        this.zlib.init(false, 0);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.zlib.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int size = DefinedPacket.readVarInt(in);
        if (size == 0) {
            out.add(in.slice().retain());
            in.skipBytes(in.readableBytes());
        } else {
            if (this.threshold != -1 && size < this.threshold) {
                throw new FastBadPacketException("Uncompressed size " + size + " is less than threshold " + this.threshold);
            }
            if (size > MAXIMUM_UNCOMPRESSED_SIZE) {
                throw new FastBadPacketException("Uncompressed size " + size + " exceeds threshold of " + MAXIMUM_UNCOMPRESSED_SIZE + ". If you're server owner launch BungeeCord with '-DmaximumPacketSize=X' before '-jar', where X is 2 = 2MiB(default), 3 = 3MiB, 8 = 8MiB, 10 = ..... For forge use 16");
            }
            if (this.checking && size > 65544) {
                throw new FastBadPacketException("Uncompressed size " + size + " exceeds threshold of " + 65544 + " (While checking)");
            }
            ByteBuf decompressed = ctx.alloc().directBuffer();
            try {
                this.zlib.process(in, decompressed);
                Preconditions.checkState(decompressed.readableBytes() == size, "Decompressed packet size mismatch");
                out.add(decompressed);
                decompressed = null;
            }
            finally {
                if (decompressed != null) {
                    decompressed.release();
                }
            }
        }
    }

    static {
        BungeeCord.getInstance().getLogger().info("[BotFilter] Maximum packet size: " + MAXIMUM_UNCOMPRESSED_SIZE);
        BungeeCord.getInstance().getLogger().info("[BotFilter] Maximum packet size while checking: " + MAXIMUM_UNCOMPRESSED_SIZE);
    }
}

