/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.protocol.DefinedPacket;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    private BungeeZlib zlib;
    private int threshold = 256;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.zlib = CompressFactory.zlib.newInstance();
        this.zlib.init(true, -1);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.zlib.free();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int origSize = msg.readableBytes();
        if (origSize < this.threshold) {
            DefinedPacket.writeVarInt(0, out);
            out.writeBytes(msg);
        } else {
            DefinedPacket.writeVarInt(origSize, out);
            this.zlib.process(msg, out);
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

