/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.SpecificTag;
import se.llbit.nbt.Tag;

public class ListTag
extends SpecificTag
implements Iterable<SpecificTag> {
    public final int type;
    public final List<SpecificTag> items;

    public static SpecificTag read(DataInputStream in) {
        try {
            byte itemType = in.readByte();
            int numItems = in.readInt();
            if (itemType == 0 && numItems > 0) {
                return new ErrorTag("Cannot create list of TAG_End");
            }
            ListTag tagThis = new ListTag(itemType, Collections.emptyList());
            for (int i = 0; i < numItems; ++i) {
                SpecificTag last = SpecificTag.read(itemType, in);
                tagThis.add(last);
            }
            return tagThis;
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_List:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.getType());
        out.writeInt(this.size());
        for (SpecificTag item : this.items) {
            item.write(out);
        }
    }

    static Map<String, Tag> partialParse(DataInputStream in, String prefix, Map<String, Tag> result, Set<String> request, Set<String> prefixes) {
        try {
            byte itemType = in.readByte();
            int numItems = in.readInt();
            if (itemType == 0 && numItems > 0) {
                return result;
            }
            for (int i = 0; i < numItems; ++i) {
                String tag = prefix + "." + i;
                boolean parsed = NamedTag.partiallyParseTag(in, result, request, prefixes, itemType, tag);
                if (parsed) {
                    if (!request.isEmpty()) continue;
                    return result;
                }
                SpecificTag.skip(itemType, in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    static void skip(DataInputStream in) {
        try {
            byte itemType = in.readByte();
            int numItems = in.readInt();
            if (itemType == 0) {
                return;
            }
            for (int i = 0; i < numItems; ++i) {
                SpecificTag.skip(itemType, in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ListTag(int type, List<? extends SpecificTag> items) {
        this.type = type;
        this.items = new ArrayList<SpecificTag>(items);
    }

    public int getType() {
        return this.type;
    }

    public int size() {
        return this.items.size();
    }

    public void add(SpecificTag node) {
        this.items.add(node);
    }

    @Override
    public void set(int i, SpecificTag node) {
        this.items.set(i, node);
    }

    @Override
    public String toString() {
        return this.dumpTree();
    }

    public String type() {
        return "TAG_List";
    }

    @Override
    public void printTag(StringBuilder buff, String indent) {
        buff.append(indent);
        this.printTagInfo(buff);
        for (Tag tag : this.items) {
            tag.printTag(buff, indent + "  ");
        }
    }

    @Override
    public String tagName() {
        return "TAG_List";
    }

    @Override
    public int tagType() {
        return 9;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public Tag get(int i) {
        return this.items.get(i);
    }

    @Override
    public Iterator<SpecificTag> iterator() {
        return this.items.iterator();
    }

    @Override
    public ListTag asList() {
        return this;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListTag)) {
            return false;
        }
        return this.items.equals(((ListTag)obj).items);
    }

    public int hashCode() {
        int code = 0;
        for (SpecificTag tag : this.items) {
            code *= 31;
            code ^= tag.hashCode();
        }
        return code;
    }
}

