/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import ru.leymooo.botfilter.BotFilter;
import ru.leymooo.botfilter.BotFilterUser;
import ru.leymooo.botfilter.config.Settings;

public class Sql {
    private final BotFilter botFilter;
    private Connection connection;
    private boolean connecting = false;
    private long nextCleanUp = System.currentTimeMillis() + 0x6DDD00L;
    private final ExecutorService executor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("BotFilter-SQL-%d").build());
    private final Logger logger = BungeeCord.getInstance().getLogger();

    public Sql(BotFilter botFilter) {
        this.botFilter = botFilter;
        this.setupConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupConnect() {
        try {
            this.connecting = true;
            if (this.executor.isShutdown()) {
                return;
            }
            if (this.connection != null && this.connection.isValid(3)) {
                return;
            }
            this.logger.info("[BotFilter] \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e\u0441\u044c \u043a \u0434\u0430\u0442\u0430\u0431\u0430\u0437\u0435...");
            long start = System.currentTimeMillis();
            if (Settings.IMP.SQL.STORAGE_TYPE.equalsIgnoreCase("mysql")) {
                Settings.SQL s2 = Settings.IMP.SQL;
                this.connectToDatabase(String.format("JDBC:mysql://%s:%s/%s?useSSL=false&useUnicode=true&characterEncoding=utf-8", s2.HOSTNAME, String.valueOf(s2.PORT), s2.DATABASE), s2.USER, s2.PASSWORD);
            } else {
                Class.forName("org.sqlite.JDBC");
                this.connectToDatabase("JDBC:sqlite:BotFilter/database.db", null, null);
            }
            this.logger.log(Level.INFO, "[BotFilter] \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e ({0} \u043c\u0441)", System.currentTimeMillis() - start);
            this.createTable();
            this.alterLastJoinColumn();
            this.clearOldUsers();
            this.loadUsers();
        }
        catch (ClassNotFoundException | SQLException e) {
            this.logger.log(Level.WARNING, "Can not connect to database or execute sql: ", e);
            this.connection = null;
        }
        finally {
            this.connecting = false;
        }
    }

    private void connectToDatabase(String url, String user, String password) throws SQLException {
        this.connection = DriverManager.getConnection(url, user, password);
    }

    private void createTable() throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS `Users` (`Name` VARCHAR(16) NOT NULL PRIMARY KEY UNIQUE,`Ip` VARCHAR(16) NOT NULL,`LastCheck` BIGINT NOT NULL,`LastJoin` BIGINT NOT NULL);";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }

    private void alterLastJoinColumn() {
        block26: {
            try (ResultSet rs = this.connection.getMetaData().getColumns(null, null, "Users", "LastJoin");){
                if (rs.next()) break block26;
                try (Statement st = this.connection.createStatement();){
                    st.executeUpdate("ALTER TABLE `Users` ADD COLUMN `LastJoin` BIGINT NOT NULL DEFAULT 0;");
                    st.executeUpdate("UPDATE `Users` SET LastJoin = LastCheck");
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "[BotFilter] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u043e\u043b\u0431\u0446\u0430 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443", e);
            }
        }
    }

    private void clearOldUsers() throws SQLException {
        if (Settings.IMP.SQL.PURGE_TIME <= 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -Settings.IMP.SQL.PURGE_TIME);
        long until = calendar.getTimeInMillis();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT `Name` FROM `Users` WHERE `LastJoin` < " + until + ";");){
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                this.botFilter.removeUser(set.getString("Name"));
            }
        }
        if (this.connection != null) {
            statement = this.connection.prepareStatement("DELETE FROM `Users` WHERE `LastJoin` < " + until + ";");
            var5_4 = null;
            try {
                this.logger.log(Level.INFO, "[BotFilter] \u041e\u0447\u0438\u0449\u0435\u043d\u043e {0} \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432", statement.executeUpdate());
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var5_4 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
    }

    private void loadUsers() throws SQLException {
        try (PreparedStatement statament = this.connection.prepareStatement("SELECT * FROM `Users`;");
             ResultSet set = statament.executeQuery();){
            int i = 0;
            while (set.next()) {
                String name = set.getString("Name");
                String ip = set.getString("Ip");
                if (this.isInvalidName(name)) {
                    this.removeUser("REMOVE FROM `Users` WHERE `Ip` = '" + ip + "' AND `LastCheck` = '" + set.getLong("LastCheck") + "';");
                    continue;
                }
                long lastCheck = set.getLong("LastCheck");
                long lastJoin = set.getLong("LastJoin");
                BotFilterUser botFilterUser = new BotFilterUser(name, ip, lastCheck, lastJoin);
                this.botFilter.addUserToCache(botFilterUser);
                ++i;
            }
            this.logger.log(Level.INFO, "[BotFilter] \u0411\u0435\u043b\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d ({0})", i);
        }
    }

    private boolean isInvalidName(String name) {
        return name.contains("'") || name.contains("\"");
    }

    private void removeUser(String sql) {
        if (this.connection != null) {
            this.executor.execute(() -> {
                try (PreparedStatement statament = this.connection.prepareStatement(sql);){
                    statament.execute();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            });
        }
    }

    public void saveUser(BotFilterUser botFilterUser) {
        if (this.connecting || this.isInvalidName(botFilterUser.getName())) {
            return;
        }
        if (this.connection != null) {
            this.executor.execute(() -> {
                long timestamp = System.currentTimeMillis();
                String sql = "SELECT `Name` FROM `Users` where `Name` = '" + botFilterUser.getName() + "' LIMIT 1;";
                try (Statement statament = this.connection.createStatement();
                     ResultSet set = statament.executeQuery(sql);){
                    if (!set.next()) {
                        sql = "INSERT INTO `Users` (`Name`, `Ip`, `LastCheck`, `LastJoin`) VALUES ('" + botFilterUser.getName() + "','" + botFilterUser.getIp() + "','" + botFilterUser.getLastCheck() + "','" + botFilterUser.getLastJoin() + "');";
                        statament.executeUpdate(sql);
                    } else {
                        sql = "UPDATE `Users` SET `Ip` = '" + botFilterUser.getIp() + "', `LastCheck` = '" + botFilterUser.getLastCheck() + "', `LastJoin` = '" + botFilterUser.getLastJoin() + "' where `Name` = '" + botFilterUser.getName() + "';";
                        statament.executeUpdate(sql);
                    }
                }
                catch (SQLException ex) {
                    this.logger.log(Level.WARNING, "[BotFilter] \u041d\u0435 \u043c\u043e\u0433\u0443 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", ex);
                    this.logger.log(Level.WARNING, sql);
                    this.executor.execute(() -> this.setupConnect());
                }
            });
        }
    }

    public void tryCleanUP() {
        if (Settings.IMP.SQL.PURGE_TIME > 0 && this.nextCleanUp - System.currentTimeMillis() <= 0L) {
            this.nextCleanUp = System.currentTimeMillis() + 0x6DDD00L;
            try {
                this.clearOldUsers();
            }
            catch (SQLException ex) {
                this.setupConnect();
                this.logger.log(Level.WARNING, "[BotFilter] \u041d\u0435 \u043c\u043e\u0433\u0443 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", ex);
            }
        }
    }

    public void close() {
        this.executor.shutdownNow();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
    }
}

