/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.utils;

public final class PingLimiter {
    private static final long ONE_MIN = 60000L;
    private static final long BAN_TIME = 300000L;
    private static int THRESHOLD = Integer.getInteger("pingThreshold", 1000);
    private static long LASTCHECK = System.currentTimeMillis();
    private static int currNumOfPings = 0;
    private static boolean banned = false;

    private PingLimiter() {
    }

    public static boolean handle() {
        ++currNumOfPings;
        long currTime = System.currentTimeMillis();
        if (banned) {
            if (currTime - LASTCHECK > 300000L) {
                banned = false;
                currNumOfPings = 0;
                LASTCHECK = currTime;
            }
            return banned;
        }
        if (currTime - LASTCHECK <= 60000L && currNumOfPings >= THRESHOLD) {
            banned = true;
            LASTCHECK = currTime;
        } else if (currTime - LASTCHECK >= 60000L) {
            currNumOfPings = 0;
            LASTCHECK = currTime;
        }
        return banned;
    }
}

