/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import com.maxmind.db.CHMCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import net.md_5.bungee.BungeeCord;
import ru.leymooo.botfilter.config.Settings;

public class GeoIp {
    private static final Logger LOGGER = BungeeCord.getInstance().getLogger();
    private final HashSet<String> countries = new HashSet();
    private final Cache<InetAddress, String> cached;
    private final boolean enabled;
    private final boolean whiteList;
    private DatabaseReader reader;

    public GeoIp(boolean startup) {
        this.enabled = Settings.IMP.GEO_IP.MODE != 2;
        boolean bl = this.whiteList = Settings.IMP.GEO_IP.TYPE == 0;
        if (this.enabled) {
            this.countries.addAll(Settings.IMP.GEO_IP.ALLOWED_COUNTRIES);
            this.setupDataBase(startup);
            this.cached = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterAccess(5L, TimeUnit.MINUTES).initialCapacity(200).build();
        } else {
            this.cached = null;
        }
    }

    public boolean isAllowed(InetAddress address) {
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            return true;
        }
        String country = this.cached.getIfPresent(address);
        if (country != null) {
            return this.whiteList ? this.countries.contains(country) : !this.countries.contains(country);
        }
        try {
            country = this.reader.country(address).getCountry().getIsoCode();
        }
        catch (GeoIp2Exception | IOException ex) {
            return false;
        }
        if (country == null) {
            return false;
        }
        this.cached.put(address, country);
        return this.whiteList ? this.countries.contains(country) : !this.countries.contains(country);
    }

    public boolean isAvailable() {
        return this.reader != null;
    }

    private void setupDataBase(boolean startup) {
        File file = new File("BotFilter", "GeoIP.mmdb");
        if (!file.exists() || startup && System.currentTimeMillis() - file.lastModified() > TimeUnit.DAYS.toMillis(14L)) {
            this.downloadDataBase(file);
        } else {
            try {
                this.reader = new DatabaseReader.Builder(file).withCache(new CHMCache(16384)).build();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "[BotFilter] \u041d\u0430 \u043c\u043e\u0433\u0443 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a GeoLite2 \u0434\u0430\u0442\u0430\u0431\u0430\u0437\u0435. \u041f\u0435\u0440\u0435\u043a\u0430\u0447\u0438\u0432\u0430\u044e", ex);
                file.delete();
                this.setupDataBase(true);
            }
        }
    }

    private void downloadDataBase(File out) {
        LOGGER.log(Level.INFO, "[BotFilter] \u0421\u043a\u0430\u0447\u0438\u0432\u0430\u044e GeoLite2 \u0434\u0430\u0442\u0430\u0431\u0430\u0437\u0443");
        long start = System.currentTimeMillis();
        try {
            block42: {
                URL downloadUrl = new URL(Settings.IMP.GEO_IP.NEW_GEOIP_DOWNLOAD_URL.replace("%license_key%", Settings.IMP.GEO_IP.MAXMIND_LICENSE_KEY));
                URLConnection conn = downloadUrl.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(10000);
                try (InputStream input = conn.getInputStream();){
                    if (downloadUrl.getFile().endsWith(".mmdb")) {
                        this.saveToFile(input, out);
                        break block42;
                    }
                    if (downloadUrl.getFile().endsWith("tar.gz")) {
                        try (GZIPInputStream gzipIn = new GZIPInputStream(input);
                             TarInputStream tarIn = new TarInputStream(gzipIn);){
                            TarEntry entry;
                            while ((entry = tarIn.getNextEntry()) != null) {
                                if (!entry.getName().endsWith("mmdb")) continue;
                                this.saveToFile(tarIn, out);
                            }
                            break block42;
                        }
                    }
                    throw new IOException("File type is not supported ");
                }
            }
            this.setupDataBase(true);
        }
        catch (Exception ex) {
            if (out.exists()) {
                this.setupDataBase(false);
            }
            LOGGER.log(Level.WARNING, "[BotFilter] \u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043a\u0430\u0447\u0430\u0442\u044c GeoLite2 \u0434\u0430\u0442\u0430\u0431\u0430\u0437\u0443", ex);
            return;
        }
        LOGGER.log(Level.INFO, "[BotFilter] GeoLite2 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 ({0}\u043c\u0441)", System.currentTimeMillis() - start);
    }

    private void saveToFile(InputStream stream, File out) throws IOException {
        try (FileOutputStream fis = new FileOutputStream(out, false);){
            byte[] buffer = new byte[2048];
            int count = 0;
            while ((count = stream.read(buffer, 0, 2048)) != -1) {
                if (Thread.interrupted()) {
                    fis.close();
                    out.delete();
                    LOGGER.log(Level.WARNING, "[BotFilter] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u0430\u0447\u0430\u0442\u044c GeoLite2 \u0434\u0430\u0442\u0430\u0431\u0430\u0437\u0443. \u0423\u0434\u0430\u043b\u044f\u044e \u043d\u0435\u0434\u043e\u043a\u0430\u0447\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b.");
                    return;
                }
                fis.write(buffer, 0, count);
            }
        }
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.cached != null) {
            this.cached.invalidateAll();
        }
    }

    public void tryClenUP() {
        if (this.cached != null) {
            this.cached.cleanUp();
        }
    }

    public Cache<InetAddress, String> getCached() {
        return this.cached;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

