/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class SetSlot
extends DefinedPacket {
    private int windowId;
    private int slot;
    private int item;
    private int count;
    private int data;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int id;
        buf.writeByte(this.windowId);
        buf.writeShort(this.slot);
        int n = id = this.item == 358 ? this.getCapthcaId(protocolVersion) : this.item;
        if (protocolVersion >= 404) {
            buf.writeBoolean(this.item >= 1);
            if (this.item <= 0) {
                return;
            }
            SetSlot.writeVarInt(id, buf);
        } else {
            buf.writeShort(id);
        }
        if (this.item >= 0) {
            buf.writeByte(this.count);
            if (protocolVersion >= 393) {
                buf.writeByte(this.data);
            } else {
                buf.writeShort(this.data);
                buf.writeByte(0);
            }
        }
    }

    private int getCapthcaId(int version) {
        if (version <= 340) {
            return 358;
        }
        if (version == 393) {
            return 608;
        }
        if (version <= 404) {
            return 613;
        }
        if (version <= 578) {
            return 671;
        }
        return 733;
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public int getData() {
        return this.data;
    }

    public void setWindowId(int windowId) {
        this.windowId = windowId;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setItem(int item) {
        this.item = item;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setData(int data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "SetSlot(windowId=" + this.getWindowId() + ", slot=" + this.getSlot() + ", item=" + this.getItem() + ", count=" + this.getCount() + ", data=" + this.getData() + ")";
    }

    public SetSlot() {
    }

    public SetSlot(int windowId, int slot, int item, int count, int data) {
        this.windowId = windowId;
        this.slot = slot;
        this.item = item;
        this.count = count;
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetSlot)) {
            return false;
        }
        SetSlot other = (SetSlot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWindowId() != other.getWindowId()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getItem() != other.getItem()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return this.getData() == other.getData();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetSlot;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWindowId();
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getItem();
        result = result * 59 + this.getCount();
        result = result * 59 + this.getData();
        return result;
    }
}

