/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class MapDataPacket
extends DefinedPacket {
    private int mapId;
    private byte scale;
    private MapData data;

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        MapDataPacket.writeVarInt(this.mapId, buf);
        buf.writeByte(this.scale);
        if (protocolVersion >= 107) {
            buf.writeBoolean(false);
        }
        if (protocolVersion >= 477) {
            buf.writeBoolean(false);
        }
        MapDataPacket.writeVarInt(0, buf);
        buf.writeByte(this.data.getColumns());
        buf.writeByte(this.data.getRows());
        buf.writeByte(this.data.getX());
        buf.writeByte(this.data.getY());
        MapDataPacket.writeArray(this.data.getData(), buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
    }

    public int getMapId() {
        return this.mapId;
    }

    public byte getScale() {
        return this.scale;
    }

    public MapData getData() {
        return this.data;
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public void setData(MapData data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "MapDataPacket(mapId=" + this.getMapId() + ", scale=" + this.getScale() + ", data=" + this.getData() + ")";
    }

    public MapDataPacket() {
    }

    public MapDataPacket(int mapId, byte scale, MapData data) {
        this.mapId = mapId;
        this.scale = scale;
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapDataPacket)) {
            return false;
        }
        MapDataPacket other = (MapDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMapId() != other.getMapId()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        MapData this$data = this.getData();
        MapData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapDataPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMapId();
        result = result * 59 + this.getScale();
        MapData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public static class MapData {
        private int columns;
        private int rows;
        private int x;
        private int y;
        private byte[] data;

        public MapData(int columns, int rows, int x, int y, byte[] data) {
            this.columns = columns;
            this.rows = rows;
            this.x = x;
            this.y = y;
            this.data = data;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

