/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class Config {
    public Config() {
        this.save(new ArrayList<String>(), this.getClass(), this, 0);
    }

    private void set(String key, Object value) {
        Field field;
        String[] split = key.split("\\.");
        Object instance = this.getInstance(split, this.getClass());
        if (instance != null && (field = this.getField(split, instance)) != null) {
            try {
                if (field.getAnnotation(Final.class) != null) {
                    return;
                }
                if (field.getType() == String.class && !(value instanceof String)) {
                    value = value + "";
                }
                field.set(instance, value);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                BungeeCord.getInstance().getLogger().log(Level.WARNING, "Error:", e);
            }
        }
        BungeeCord.getInstance().getLogger().log(Level.WARNING, "[BotFilter] Failed to set config option: {0}: {1} | {2} ", new Object[]{key, value, instance});
    }

    public boolean load(File file) {
        Configuration yml;
        if (!file.exists()) {
            return false;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            yml = ConfigurationProvider.getProvider(YamlConfiguration.class).load(reader);
        }
        catch (IOException ex) {
            BungeeCord.getInstance().getLogger().log(Level.WARNING, "[BotFilter] \u041d\u0435 \u043c\u043e\u0433\u0443 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433 ", ex);
            return false;
        }
        this.set(yml, "");
        return true;
    }

    public void set(Configuration yml, String oldPath) {
        for (String key : yml.getKeys()) {
            Object value = yml.get(key);
            String newPath = oldPath + (oldPath.isEmpty() ? "" : ".") + key;
            if (value instanceof Configuration) {
                this.set((Configuration)value, newPath);
                continue;
            }
            this.set(newPath, value);
        }
    }

    public void save(File file) {
        try {
            File parent = file.getParentFile();
            if (parent != null) {
                file.getParentFile().mkdirs();
            }
            Path configFile = file.toPath();
            Path tempCfg = new File(file.getParentFile(), "__tmpcfg").toPath();
            ArrayList<String> lines = new ArrayList<String>();
            this.save(lines, this.getClass(), this, 0);
            Files.write(tempCfg, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            try {
                Files.move(tempCfg, configFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tempCfg, configFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            BungeeCord.getInstance().getLogger().log(Level.WARNING, "Error:", e);
        }
    }

    private String toYamlString(Object value, String spacing) {
        if (value instanceof List) {
            Collection listValue = (Collection)value;
            if (listValue.isEmpty()) {
                return "[]";
            }
            StringBuilder m3 = new StringBuilder();
            for (Object obj : listValue) {
                m3.append(System.lineSeparator()).append(spacing).append("- ").append(this.toYamlString(obj, spacing));
            }
            return m3.toString();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return "''";
            }
            return "\"" + stringValue + "\"";
        }
        return value != null ? value.toString() : "null";
    }

    private void save(List<String> lines, Class clazz, Object instance, int indent) {
        try {
            String spacing = this.repeat(" ", indent);
            for (Field field : clazz.getFields()) {
                Create create;
                if (field.getAnnotation(Ignore.class) != null) continue;
                Class<?> current = field.getType();
                if (field.getAnnotation(Ignore.class) != null) continue;
                Comment comment = field.getAnnotation(Comment.class);
                if (comment != null) {
                    for (String commentLine : comment.value()) {
                        lines.add(spacing + "# " + commentLine);
                    }
                }
                if ((create = field.getAnnotation(Create.class)) != null) {
                    Object value = field.get(instance);
                    this.setAccessible(field);
                    if (indent == 0) {
                        lines.add("");
                    }
                    if ((comment = current.getAnnotation(Comment.class)) != null) {
                        for (String commentLine : comment.value()) {
                            lines.add(spacing + "# " + commentLine);
                        }
                    }
                    lines.add(spacing + this.toNodeName(current.getSimpleName()) + ":");
                    if (value == null) {
                        value = current.newInstance();
                        field.set(instance, value);
                    }
                    this.save(lines, current, value, indent + 2);
                    continue;
                }
                lines.add(spacing + this.toNodeName(field.getName() + ": ") + this.toYamlString(field.get(instance), spacing));
            }
        }
        catch (Exception e) {
            BungeeCord.getInstance().getLogger().log(Level.WARNING, "Error:", e);
        }
    }

    private Field getField(String[] split, Object instance) {
        try {
            Field field = instance.getClass().getField(this.toFieldName(split[split.length - 1]));
            this.setAccessible(field);
            return field;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BungeeCord.getInstance().getLogger().log(Level.WARNING, "[BotFilter] Invalid config field: {0} for {1}", new Object[]{String.join((CharSequence)".", split), this.toNodeName(instance.getClass().getSimpleName())});
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getInstance(String[] split, Class root) {
        try {
            Class<?> clazz = root == null ? MethodHandles.lookup().lookupClass() : root;
            Object instance = this;
            while (split.length > 0) {
                Class<?>[] classes;
                switch (split.length) {
                    case 1: {
                        return instance;
                    }
                }
                Class<?> found = null;
                for (Class<?> current : classes = clazz.getDeclaredClasses()) {
                    if (!current.getSimpleName().equalsIgnoreCase(this.toFieldName(split[0]))) continue;
                    found = current;
                    break;
                }
                try {
                    Field instanceField = clazz.getDeclaredField(this.toFieldName(split[0]));
                    this.setAccessible(instanceField);
                    Object value = instanceField.get(instance);
                    if (value == null) {
                        value = found.newInstance();
                        instanceField.set(instance, value);
                    }
                    clazz = found;
                    instance = value;
                    split = Arrays.copyOfRange(split, 1, split.length);
                }
                catch (NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String toFieldName(String node) {
        return node.toUpperCase().replaceAll("-", "_");
    }

    private String toNodeName(String field) {
        return field.toLowerCase().replace("_", "-");
    }

    private void setAccessible(Field field) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        field.setAccessible(true);
        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
            }
            catch (NoSuchFieldException e) {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field classField : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(classField.getName())) continue;
                    classField.setAccessible(true);
                    classField.set(field, modifiers & 0xFFFFFFEF);
                    break;
                }
            }
        }
    }

    private String repeat(String s2, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s2);
        }
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Comment {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Final {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Create {
    }
}

