/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.captcha.generator.map;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public final class MapPalette {
    private static final ThreadLocal<int[]> rgbBuffer = ThreadLocal.withInitial(() -> new int[16384]);
    public static final Color[] colors = new Color[]{MapPalette.c(0, 0, 0), MapPalette.c(0, 0, 0), MapPalette.c(0, 0, 0), MapPalette.c(0, 0, 0), MapPalette.c(89, 125, 39), MapPalette.c(109, 153, 48), MapPalette.c(127, 178, 56), MapPalette.c(67, 94, 29), MapPalette.c(174, 164, 115), MapPalette.c(213, 201, 140), MapPalette.c(247, 233, 163), MapPalette.c(130, 123, 86), MapPalette.c(140, 140, 140), MapPalette.c(171, 171, 171), MapPalette.c(199, 199, 199), MapPalette.c(105, 105, 105), MapPalette.c(180, 0, 0), MapPalette.c(220, 0, 0), MapPalette.c(255, 0, 0), MapPalette.c(135, 0, 0), MapPalette.c(112, 112, 180), MapPalette.c(138, 138, 220), MapPalette.c(160, 160, 255), MapPalette.c(84, 84, 135), MapPalette.c(117, 117, 117), MapPalette.c(144, 144, 144), MapPalette.c(167, 167, 167), MapPalette.c(88, 88, 88), MapPalette.c(0, 87, 0), MapPalette.c(0, 106, 0), MapPalette.c(0, 124, 0), MapPalette.c(0, 65, 0), MapPalette.c(180, 180, 180), MapPalette.c(220, 220, 220), MapPalette.c(255, 255, 255), MapPalette.c(135, 135, 135), MapPalette.c(115, 118, 129), MapPalette.c(141, 144, 158), MapPalette.c(164, 168, 184), MapPalette.c(86, 88, 97), MapPalette.c(106, 76, 54), MapPalette.c(130, 94, 66), MapPalette.c(151, 109, 77), MapPalette.c(79, 57, 40), MapPalette.c(79, 79, 79), MapPalette.c(96, 96, 96), MapPalette.c(112, 112, 112), MapPalette.c(59, 59, 59), MapPalette.c(45, 45, 180), MapPalette.c(55, 55, 220), MapPalette.c(64, 64, 255), MapPalette.c(33, 33, 135), MapPalette.c(100, 84, 50), MapPalette.c(123, 102, 62), MapPalette.c(143, 119, 72), MapPalette.c(75, 63, 38), MapPalette.c(180, 177, 172), MapPalette.c(220, 217, 211), MapPalette.c(255, 252, 245), MapPalette.c(135, 133, 129), MapPalette.c(152, 89, 36), MapPalette.c(186, 109, 44), MapPalette.c(216, 127, 51), MapPalette.c(114, 67, 27), MapPalette.c(125, 53, 152), MapPalette.c(153, 65, 186), MapPalette.c(178, 76, 216), MapPalette.c(94, 40, 114), MapPalette.c(72, 108, 152), MapPalette.c(88, 132, 186), MapPalette.c(102, 153, 216), MapPalette.c(54, 81, 114), MapPalette.c(161, 161, 36), MapPalette.c(197, 197, 44), MapPalette.c(229, 229, 51), MapPalette.c(121, 121, 27), MapPalette.c(89, 144, 17), MapPalette.c(109, 176, 21), MapPalette.c(127, 204, 25), MapPalette.c(67, 108, 13), MapPalette.c(170, 89, 116), MapPalette.c(208, 109, 142), MapPalette.c(242, 127, 165), MapPalette.c(128, 67, 87), MapPalette.c(53, 53, 53), MapPalette.c(65, 65, 65), MapPalette.c(76, 76, 76), MapPalette.c(40, 40, 40), MapPalette.c(108, 108, 108), MapPalette.c(132, 132, 132), MapPalette.c(153, 153, 153), MapPalette.c(81, 81, 81), MapPalette.c(53, 89, 108), MapPalette.c(65, 109, 132), MapPalette.c(76, 127, 153), MapPalette.c(40, 67, 81), MapPalette.c(89, 44, 125), MapPalette.c(109, 54, 153), MapPalette.c(127, 63, 178), MapPalette.c(67, 33, 94), MapPalette.c(36, 53, 125), MapPalette.c(44, 65, 153), MapPalette.c(51, 76, 178), MapPalette.c(27, 40, 94), MapPalette.c(72, 53, 36), MapPalette.c(88, 65, 44), MapPalette.c(102, 76, 51), MapPalette.c(54, 40, 27), MapPalette.c(72, 89, 36), MapPalette.c(88, 109, 44), MapPalette.c(102, 127, 51), MapPalette.c(54, 67, 27), MapPalette.c(108, 36, 36), MapPalette.c(132, 44, 44), MapPalette.c(153, 51, 51), MapPalette.c(81, 27, 27), MapPalette.c(17, 17, 17), MapPalette.c(21, 21, 21), MapPalette.c(25, 25, 25), MapPalette.c(13, 13, 13), MapPalette.c(176, 168, 54), MapPalette.c(215, 205, 66), MapPalette.c(250, 238, 77), MapPalette.c(132, 126, 40), MapPalette.c(64, 154, 150), MapPalette.c(79, 188, 183), MapPalette.c(92, 219, 213), MapPalette.c(48, 115, 112), MapPalette.c(52, 90, 180), MapPalette.c(63, 110, 220), MapPalette.c(74, 128, 255), MapPalette.c(39, 67, 135), MapPalette.c(0, 153, 40), MapPalette.c(0, 187, 50), MapPalette.c(0, 217, 58), MapPalette.c(0, 114, 30), MapPalette.c(91, 60, 34), MapPalette.c(111, 74, 42), MapPalette.c(129, 86, 49), MapPalette.c(68, 45, 25), MapPalette.c(79, 1, 0), MapPalette.c(96, 1, 0), MapPalette.c(112, 2, 0), MapPalette.c(59, 1, 0)};
    private static final Map<Integer, Byte> colorToIndexMap = new HashMap<Integer, Byte>();

    public static void prepareColors() {
        for (int i = 4; i < colors.length; ++i) {
            Color color = colors[i];
            byte index = (byte)(i < 128 ? i : -129 + (i - 127));
            colorToIndexMap.put(color.getRGB(), index);
        }
    }

    private static Color c(int r, int g2, int b) {
        return new Color(r, g2, b);
    }

    private static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g2 = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g2 * g2 + weightB * (double)b * (double)b;
    }

    @Deprecated
    public static int[] imageToBytes(BufferedImage image) {
        int[] result = rgbBuffer.get();
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), result, 0, image.getWidth());
        for (int i = 0; i < result.length; ++i) {
            result[i] = MapPalette.tryFastMatchColor(result[i]);
        }
        return result;
    }

    public static byte tryFastMatchColor(int rgb) {
        Byte color = colorToIndexMap.get(rgb);
        if (color != null) {
            return color;
        }
        return MapPalette.matchColor(new Color(rgb, true));
    }

    @Deprecated
    public static byte matchColor(Color color) {
        if (color.getAlpha() < 128) {
            return 0;
        }
        int index = 0;
        double best = -1.0;
        for (int i = 4; i < colors.length; ++i) {
            double distance = MapPalette.getDistance(color, colors[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        return (byte)(index < 128 ? index : -129 + (index - 127));
    }
}

