/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.captcha.generator;

import java.awt.image.BufferedImage;

public class Rippler {
    private final AxisConfig vertical;
    private final AxisConfig horizontal;

    public Rippler(AxisConfig vertical, AxisConfig horizontal) {
        this.vertical = vertical;
        this.horizontal = horizontal;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] verticalDelta = this.calcDeltaArray(this.vertical, width);
        int[] horizontalDelta = this.calcDeltaArray(this.horizontal, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int ny = (y + verticalDelta[x] + height) % height;
                int nx = (x + horizontalDelta[ny] + width) % width;
                dest.setRGB(nx, ny, src.getRGB(x, y));
            }
        }
        return dest;
    }

    protected int[] calcDeltaArray(AxisConfig axisConfig, int num) {
        int[] delta = new int[num];
        double start = axisConfig.getStart();
        double period = axisConfig.getLength() / (double)num;
        double amplitude = axisConfig.getAmplitude();
        for (int fi = 0; fi < num; ++fi) {
            delta[fi] = (int)Math.round(amplitude * Math.sin(start + (double)fi * period));
        }
        return delta;
    }

    public AxisConfig getVertical() {
        return this.vertical;
    }

    public AxisConfig getHorizontal() {
        return this.horizontal;
    }

    public static class AxisConfig {
        private final double start;
        private final double length;
        private final double amplitude;

        public AxisConfig(double start, double length, double amplitude) {
            this.start = this.normalize(start, 2);
            this.length = this.normalize(length, 4);
            this.amplitude = amplitude;
        }

        protected double normalize(double a, int multi) {
            double piMulti = (double)multi * Math.PI;
            a = Math.abs(a);
            double d = Math.floor(a / piMulti);
            return a - d * piMulti;
        }

        public double getStart() {
            return this.start;
        }

        public double getLength() {
            return this.length;
        }

        public double getAmplitude() {
            return this.amplitude;
        }
    }
}

