/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.captcha.generator;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Random;
import ru.leymooo.botfilter.captcha.generator.Rippler;

public class CaptchaPainter {
    private final int width = 128;
    private final int height = 128;
    private final Color background = Color.WHITE;
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage draw(Font font, Color fGround, String text) {
        if (font == null) {
            throw new IllegalArgumentException("Font can not be null.");
        }
        if (fGround == null) {
            throw new IllegalArgumentException("Foreground color can not be null.");
        }
        if (text == null || text.length() < 1) {
            throw new IllegalArgumentException("No text given.");
        }
        BufferedImage img = this.createImage();
        Graphics g2 = img.getGraphics();
        try {
            Graphics2D g22 = this.configureGraphics(g2, font, fGround);
            this.draw(g22, text);
        }
        finally {
            g2.dispose();
        }
        img = this.postProcess(img);
        return img;
    }

    protected BufferedImage createImage() {
        return new BufferedImage(128, 128, 5);
    }

    protected Graphics2D configureGraphics(Graphics g2, Font font, Color fGround) {
        if (!(g2 instanceof Graphics2D)) {
            throw new IllegalStateException("Graphics (" + g2 + ") that is not an instance of Graphics2D.");
        }
        Graphics2D g22 = (Graphics2D)g2;
        this.configureGraphicsQuality(g22);
        g22.setColor(fGround);
        g22.setBackground(this.background);
        g22.setFont(font);
        g22.clearRect(0, 0, 128, 128);
        return g22;
    }

    protected void configureGraphicsQuality(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    protected void draw(Graphics2D g2, String text) {
        GlyphVector vector = g2.getFont().createGlyphVector(g2.getFontRenderContext(), text);
        this.transform(g2, text, vector);
        Rectangle bounds = vector.getPixelBounds(null, 0.0f, 128.0f);
        float bw = (float)bounds.getWidth();
        float bh = (float)bounds.getHeight();
        boolean outlineEnabled = true;
        float wr = 128.0f / bw * (this.rnd.nextFloat() / 20.0f + 0.89f) * 1.0f;
        float hr = 128.0f / bh * (this.rnd.nextFloat() / 20.0f + 0.68f) * 1.0f;
        g2.translate((128.0f - bw * wr) / 2.0f, (128.0f - bh * hr) / 2.0f);
        g2.scale(wr, hr);
        float bx = (float)bounds.getX();
        float by = (float)bounds.getY();
        g2.draw(vector.getOutline(Math.signum(this.rnd.nextFloat() - 0.5f) * 1.0f * 128.0f / 200.0f - bx, Math.signum(this.rnd.nextFloat() - 0.5f) * 1.0f * 128.0f / 70.0f + 128.0f - by));
        g2.drawGlyphVector(vector, -bx, 128.0f - by);
    }

    protected void transform(Graphics2D g2, String text, GlyphVector v) {
        int glyphNum = v.getNumGlyphs();
        Point2D.Double prePos = null;
        RectangularShape preBounds = null;
        double rotateCur = (this.rnd.nextDouble() - 0.5) * Math.PI / 8.0;
        double rotateStep = Math.signum(rotateCur) * (this.rnd.nextDouble() * 3.0 * Math.PI / 8.0 / (double)glyphNum);
        boolean rotateEnabled = true;
        for (int fi = 0; fi < glyphNum; ++fi) {
            AffineTransform tr = AffineTransform.getRotateInstance(rotateCur);
            if (this.rnd.nextDouble() < 0.25) {
                rotateStep *= -1.0;
            }
            rotateCur += rotateStep;
            v.setGlyphTransform(fi, tr);
            Point2D pos = v.getGlyphPosition(fi);
            Rectangle2D bounds = v.getGlyphVisualBounds(fi).getBounds2D();
            Point2D.Double newPos = prePos == null ? new Point2D.Double(pos.getX() - bounds.getX(), pos.getY()) : new Point2D.Double(preBounds.getMaxX() + pos.getX() - bounds.getX() - Math.min(preBounds.getWidth(), bounds.getWidth()) * (this.rnd.nextDouble() / 20.0 + 0.27), pos.getY());
            v.setGlyphPosition(fi, newPos);
            prePos = newPos;
            preBounds = v.getGlyphVisualBounds(fi).getBounds2D();
        }
    }

    protected BufferedImage postProcess(BufferedImage img) {
        Rippler.AxisConfig vertical = new Rippler.AxisConfig(this.rnd.nextDouble() * 2.0 * Math.PI, (1.0 + this.rnd.nextDouble() * 2.0) * Math.PI, (double)img.getHeight() / 10.0);
        Rippler.AxisConfig horizontal = new Rippler.AxisConfig(this.rnd.nextDouble() * 2.0 * Math.PI, (2.0 + this.rnd.nextDouble() * 2.0) * Math.PI, (double)img.getWidth() / 100.0);
        Rippler op = new Rippler(vertical, horizontal);
        img = op.filter(img, this.createImage());
        float[] blurArray = new float[9];
        this.fillBlurArray(blurArray);
        ConvolveOp op2 = new ConvolveOp(new Kernel(3, 3, blurArray), 1, null);
        img = op2.filter(img, this.createImage());
        return img;
    }

    protected void fillBlurArray(float[] array) {
        int fi;
        float sum = 0.0f;
        for (fi = 0; fi < array.length; ++fi) {
            array[fi] = this.rnd.nextFloat();
            sum += array[fi];
        }
        fi = 0;
        while (fi < array.length) {
            int n = fi++;
            array[n] = array[n] / sum;
        }
    }
}

