/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.captcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import ru.leymooo.botfilter.caching.CachedCaptcha;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.captcha.generator.CaptchaPainter;
import ru.leymooo.botfilter.captcha.generator.map.CraftMapCanvas;
import ru.leymooo.botfilter.captcha.generator.map.MapPalette;
import ru.leymooo.botfilter.packets.MapDataPacket;

public final class CaptchaGeneration {
    static Random rnd = new Random();

    public static void generateImages() {
        Font[] fonts = new Font[]{new Font("SansSerif", 0, 50), new Font("Serif", 0, 50), new Font("Monospaced", 1, 50)};
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        CaptchaPainter painter = new CaptchaPainter();
        MapPalette.prepareColors();
        for (int i = 100; i <= 999; ++i) {
            executor.execute(() -> {
                String answer = CaptchaGeneration.randomAnswer();
                BufferedImage image = painter.draw(fonts[rnd.nextInt(fonts.length)], CaptchaGeneration.randomNotWhiteColor(), answer);
                CraftMapCanvas map = new CraftMapCanvas();
                map.drawImage(0, 0, image);
                MapDataPacket packet = new MapDataPacket(0, 0, map.getMapData());
                PacketUtils.captchas.createCaptchaPacket(packet, answer);
            });
        }
        long start = System.currentTimeMillis();
        ThreadPoolExecutor ex = (ThreadPoolExecutor)executor;
        while (ex.getActiveCount() != 0) {
            BungeeCord.getInstance().getLogger().log(Level.INFO, "[BotFilter] \u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u044e \u043a\u0430\u043f\u0447\u0443 [{0}/900]", 900 - ex.getQueue().size() - ex.getActiveCount());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex1) {
                BungeeCord.getInstance().getLogger().log(Level.WARNING, "[BotFilter] \u041d\u0435\u043c\u043e\u0433\u0443 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u043f\u0447\u0443. \u0412\u044b\u043a\u043b\u044e\u0447\u0430\u044e \u0431\u0430\u043d\u0434\u0436\u0443", ex1);
                System.exit(0);
                return;
            }
        }
        CachedCaptcha.generated = true;
        executor.shutdownNow();
        System.gc();
        BungeeCord.getInstance().getLogger().log(Level.INFO, "[BotFilter] \u041a\u0430\u043f\u0447\u0430 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430 \u0437\u0430 {0} \u043c\u0441", System.currentTimeMillis() - start);
    }

    private static Color randomNotWhiteColor() {
        Color color = MapPalette.colors[rnd.nextInt(MapPalette.colors.length)];
        if (color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255) {
            return CaptchaGeneration.randomNotWhiteColor();
        }
        if (color.getRed() == 220 && color.getGreen() == 220 && color.getBlue() == 220) {
            return CaptchaGeneration.randomNotWhiteColor();
        }
        return color;
    }

    private static String randomAnswer() {
        if (rnd.nextBoolean()) {
            return Integer.toString(rnd.nextInt(90000) + 10000);
        }
        return Integer.toString(rnd.nextInt(9000) + 1000);
    }

    private CaptchaGeneration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

