/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.caching;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Title;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.config.Settings;

public class CachedTitle {
    private ByteBuf[] times;
    private ByteBuf[] title = null;
    private ByteBuf[] subtitle = null;

    public CachedTitle(String raw, int in, int stay, int out) {
        if (!raw.isEmpty()) {
            String subtitle;
            String[] titles = raw.replace("%prefix%", Settings.IMP.MESSAGES.PREFIX).split("%nl%");
            String title = titles[0];
            String string = subtitle = titles.length == 2 ? titles[1] : null;
            if (!title.isEmpty()) {
                this.title = new ByteBuf[PacketUtils.PROTOCOLS_COUNT];
                Title titlePacket = new Title();
                titlePacket.setAction(Title.Action.TITLE);
                titlePacket.setText(ComponentSerializer.toString(TextComponent.fromLegacyText(ChatColor.translateAlternateColorCodes('&', title))));
                PacketUtils.fillArray(this.title, titlePacket, Protocol.GAME);
            }
            if (subtitle != null && !subtitle.isEmpty()) {
                this.subtitle = new ByteBuf[PacketUtils.PROTOCOLS_COUNT];
                Title subTitlePacket = new Title();
                subTitlePacket.setAction(Title.Action.SUBTITLE);
                subTitlePacket.setText(ComponentSerializer.toString(TextComponent.fromLegacyText(ChatColor.translateAlternateColorCodes('&', subtitle))));
                PacketUtils.fillArray(this.subtitle, subTitlePacket, Protocol.GAME);
            }
            if (this.title != null || this.subtitle != null) {
                this.times = new ByteBuf[PacketUtils.PROTOCOLS_COUNT];
                Title times = new Title();
                times.setFadeIn(in);
                times.setStay(stay);
                times.setFadeOut(out);
                times.setAction(Title.Action.TIMES);
                PacketUtils.fillArray(this.times, times, Protocol.GAME);
            }
        }
    }

    public void writeTitle(Channel channel, int version) {
        version = PacketUtils.rewriteVersion(version);
        if (this.times != null) {
            channel.write(this.times[version].retainedDuplicate());
        }
        if (this.title != null) {
            channel.write(this.title[version].retainedDuplicate());
        }
        if (this.subtitle != null) {
            channel.write(this.subtitle[version].retainedDuplicate());
        }
    }

    public void test() {
        this.times[0].retainedDuplicate().release();
        this.title[0].retainedDuplicate().release();
        this.subtitle[0].retainedDuplicate().release();
    }

    public void release() {
        if (this.title != null) {
            for (ByteBuf buf : this.title) {
                PacketUtils.releaseByteBuf(buf);
            }
            this.title = null;
        }
        if (this.subtitle != null) {
            for (ByteBuf buf : this.subtitle) {
                PacketUtils.releaseByteBuf(buf);
            }
            this.subtitle = null;
        }
        if (this.times != null) {
            for (ByteBuf buf : this.times) {
                PacketUtils.releaseByteBuf(buf);
            }
            this.times = null;
        }
    }
}

