/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.caching;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import ru.leymooo.botfilter.caching.PacketUtils;

public class CachedPacket {
    private ByteBuf[] byteBuf = new ByteBuf[PacketUtils.PROTOCOLS_COUNT];

    public CachedPacket(DefinedPacket packet, Protocol ... protocols) {
        if (packet != null) {
            PacketUtils.fillArray(this.byteBuf, packet, protocols);
        }
    }

    public ByteBuf get(int version) {
        ByteBuf buf = this.byteBuf[PacketUtils.rewriteVersion(version)];
        return buf == null ? null : buf.retainedDuplicate();
    }

    public void release() {
        if (this.byteBuf != null) {
            for (ByteBuf buf : this.byteBuf) {
                PacketUtils.releaseByteBuf(buf);
            }
            this.byteBuf = null;
        }
    }
}

