/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.caching;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.Protocol;
import ru.leymooo.botfilter.Connector;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.packets.SetExp;

public class CachedExpPackets {
    private ByteBuf[][] byteBuf = new ByteBuf[Connector.TOTAL_TICKS][PacketUtils.PROTOCOLS_COUNT];

    public CachedExpPackets() {
        this.create();
    }

    private void create() {
        int ticks = Connector.TOTAL_TICKS;
        int interval = 2;
        float expinterval = 1.0f / ((float)ticks / (float)interval);
        SetExp setExp = new SetExp(0.0f, 0, 0);
        for (int i = 0; i < ticks; i += interval) {
            setExp.setExpBar(setExp.getExpBar() + expinterval);
            setExp.setLevel(setExp.getLevel() + 1);
            PacketUtils.fillArray(this.byteBuf[i], setExp, Protocol.BotFilter);
        }
    }

    public ByteBuf get(int tick, int version) {
        ByteBuf buf = this.byteBuf[tick][PacketUtils.rewriteVersion(version)];
        return buf == null ? null : buf.retainedDuplicate();
    }

    public void release() {
        for (int i = 0; i < this.byteBuf.length; ++i) {
            if (this.byteBuf[i] == null) continue;
            for (ByteBuf buf : this.byteBuf[i]) {
                PacketUtils.releaseByteBuf(buf);
            }
            this.byteBuf[i] = null;
        }
        this.byteBuf = null;
    }
}

