/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter.caching;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.packets.MapDataPacket;

public class CachedCaptcha {
    private static final int PACKETID_18 = 52;
    private static final int PACKETID_19 = 36;
    private static final int PACKETID_113 = 38;
    private static final int PACKETID_114and116 = 38;
    private static final int PACKETID_115 = 39;
    private static final int PACKETID_1162 = 37;
    private static final Random random = new Random();
    private static final CaptchaHolder[] captchas = new CaptchaHolder[900];
    private static final AtomicInteger counter = new AtomicInteger();
    public static boolean generated = false;

    public void createCaptchaPacket(MapDataPacket map, String answer) {
        ByteBuf byteBuf18 = PacketUtils.createPacket(map, 52, 47);
        ByteBuf byteBuf19 = PacketUtils.createPacket(map, 36, 107);
        ByteBuf byteBuf113 = PacketUtils.createPacket(map, 38, 393);
        ByteBuf byteBuf114And116 = PacketUtils.createPacket(map, 38, 477);
        ByteBuf byteBuf115 = PacketUtils.createPacket(map, 39, 573);
        ByteBuf byteBuf1162 = PacketUtils.createPacket(map, 37, 751);
        CachedCaptcha.captchas[CachedCaptcha.counter.getAndIncrement()] = new CaptchaHolder(answer, byteBuf18, byteBuf19, byteBuf113, byteBuf114And116, byteBuf115, byteBuf1162);
    }

    public CaptchaHolder randomCaptcha() {
        return captchas[random.nextInt(captchas.length)];
    }

    public static class CaptchaHolder {
        private final String answer;
        private final ByteBuf buf18;
        private final ByteBuf buf19;
        private final ByteBuf buf113;
        private final ByteBuf buf114And116;
        private final ByteBuf buf115;
        private final ByteBuf buf1162;

        public void write(Channel channel, int version, boolean flush) {
            if (version == 47) {
                channel.write(this.buf18.retainedDuplicate(), channel.voidPromise());
            } else if (version <= 340) {
                channel.write(this.buf19.retainedDuplicate(), channel.voidPromise());
            } else if (version <= 404) {
                channel.write(this.buf113.retainedDuplicate(), channel.voidPromise());
            } else if (version <= 498) {
                channel.write(this.buf114And116.retainedDuplicate(), channel.voidPromise());
            } else if (version <= 578) {
                channel.write(this.buf115.retainedDuplicate(), channel.voidPromise());
            } else if (version <= 736) {
                channel.write(this.buf114And116.retainedDuplicate(), channel.voidPromise());
            } else if (version <= 754) {
                channel.write(this.buf1162.retainedDuplicate(), channel.voidPromise());
            } else {
                throw new IllegalArgumentException("version not found: " + version);
            }
            if (flush) {
                channel.flush();
            }
        }

        public CaptchaHolder(String answer, ByteBuf buf18, ByteBuf buf19, ByteBuf buf113, ByteBuf buf114And116, ByteBuf buf115, ByteBuf buf1162) {
            this.answer = answer;
            this.buf18 = buf18;
            this.buf19 = buf19;
            this.buf113 = buf113;
            this.buf114And116 = buf114And116;
            this.buf115 = buf115;
            this.buf1162 = buf1162;
        }

        public String getAnswer() {
            return this.answer;
        }

        public ByteBuf getBuf18() {
            return this.buf18;
        }

        public ByteBuf getBuf19() {
            return this.buf19;
        }

        public ByteBuf getBuf113() {
            return this.buf113;
        }

        public ByteBuf getBuf114And116() {
            return this.buf114And116;
        }

        public ByteBuf getBuf115() {
            return this.buf115;
        }

        public ByteBuf getBuf1162() {
            return this.buf1162;
        }
    }
}

