/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.PluginMessage;
import ru.leymooo.botfilter.BotFilter;
import ru.leymooo.botfilter.MoveHandler;
import ru.leymooo.botfilter.caching.CachedCaptcha;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.caching.PacketsPosition;
import ru.leymooo.botfilter.config.Settings;
import ru.leymooo.botfilter.utils.FailedUtils;
import ru.leymooo.botfilter.utils.IPUtils;
import ru.leymooo.botfilter.utils.ManyChecksUtils;

public class Connector
extends MoveHandler {
    private static final Logger LOGGER = BungeeCord.getInstance().getLogger();
    public static int TOTAL_TICKS = 100;
    private static long TOTAL_TIME = TOTAL_TICKS * 50 - 100;
    private final BotFilter botFilter;
    private final String name;
    private final String ip;
    private final int version;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private UserConnection userConnection;
    private BotFilter.CheckState state = BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED;
    private Channel channel;
    private String captchaAnswer;
    private int aticks = 0;
    private int sentPings = 0;
    private int attemps = 3;
    private long joinTime = System.currentTimeMillis();
    private long lastSend = 0L;
    private long totalping = 9999L;
    private boolean markDisconnected = false;

    public Connector(UserConnection userConnection, BotFilter botFilter) {
        this.botFilter = botFilter;
        this.state = this.botFilter.getCurrentCheckState();
        this.name = userConnection.getName();
        this.channel = userConnection.getCh().getHandle();
        this.userConnection = userConnection;
        this.version = userConnection.getPendingConnection().getVersion();
        this.userConnection.setClientEntityId(PacketUtils.CLIENTID);
        this.userConnection.setDimension(0);
        this.ip = IPUtils.getAddress(this.userConnection).getHostAddress();
    }

    public void spawn() {
        this.botFilter.incrementBotCounter();
        if (!Settings.IMP.PROTECTION.ALWAYS_CHECK) {
            ManyChecksUtils.IncreaseOrAdd(IPUtils.getAddress(this.userConnection));
        }
        if (this.state == BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED) {
            PacketUtils.spawnPlayer(this.channel, this.userConnection.getPendingConnection().getVersion(), false, false);
            PacketUtils.titles[0].writeTitle(this.channel, this.version);
        } else {
            PacketUtils.spawnPlayer(this.channel, this.userConnection.getPendingConnection().getVersion(), this.state == BotFilter.CheckState.ONLY_CAPTCHA, true);
            this.sendCaptcha();
            PacketUtils.titles[1].writeTitle(this.channel, this.version);
        }
        this.sendPing();
        LOGGER.log(Level.INFO, this.toString() + " has connected");
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.markDisconnected = true;
        if (this.state == BotFilter.CheckState.FAILED) {
            this.channel.close();
        } else {
            this.userConnection.disconnect(Util.exception(t));
        }
        this.disconnected();
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (packet.packet == null && packet.buf.readableBytes() > 2048) {
            this.failed(PacketUtils.KickType.BIG_PACKET, "Sent packet larger than 2048 bytes (" + packet.buf.readableBytes() + ")");
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        switch (this.state) {
            case ONLY_CAPTCHA: 
            case ONLY_POSITION: 
            case CAPTCHA_POSITION: {
                String info = "(BF) [" + this.name + "|" + this.ip + "] leaved from server during check";
                LOGGER.log(Level.INFO, info);
                FailedUtils.addIpToQueue(this.ip, PacketUtils.KickType.LEAVED);
            }
        }
        this.botFilter.removeConnection(null, this);
        this.disconnected();
    }

    @Override
    public void handlerChanged() {
        this.disconnected();
    }

    private void disconnected() {
        this.channel = null;
        this.userConnection = null;
    }

    public void completeCheck() {
        if (System.currentTimeMillis() - this.joinTime < TOTAL_TIME && this.state != BotFilter.CheckState.ONLY_CAPTCHA) {
            if (this.state == BotFilter.CheckState.CAPTCHA_POSITION && this.aticks < TOTAL_TICKS) {
                this.channel.writeAndFlush(PacketUtils.getCachedPacket(PacketsPosition.SETSLOT_RESET).get(this.version), this.channel.voidPromise());
                this.state = BotFilter.CheckState.ONLY_POSITION;
            } else if (this.state == BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED) {
                this.changeStateToCaptcha();
            } else {
                this.failed(PacketUtils.KickType.FAILED_FALLING, "Too fast check passed");
            }
            return;
        }
        int devide = this.lastSend == 0L ? this.sentPings : this.sentPings - 1;
        if (this.botFilter.checkBigPing(this.totalping / (long)(devide <= 0 ? 1 : devide))) {
            this.failed(PacketUtils.KickType.PING, "Big ping");
            return;
        }
        this.state = BotFilter.CheckState.SUCCESSFULLY;
        PacketUtils.titles[2].writeTitle(this.channel, this.version);
        this.channel.flush();
        this.botFilter.removeConnection(null, this);
        this.sendMessage(PacketsPosition.CHECK_SUS);
        this.botFilter.saveUser(this.getName(), IPUtils.getAddress(this.userConnection), true);
        PacketDecompressor packetDecompressor = this.channel.pipeline().get(PacketDecompressor.class);
        if (packetDecompressor != null) {
            packetDecompressor.checking = false;
        }
        this.userConnection.setNeedLogin(false);
        this.userConnection.getPendingConnection().finishLogin(this.userConnection, true);
        this.markDisconnected = true;
        LOGGER.log(Level.INFO, "[BotFilter] \u0418\u0433\u0440\u043e\u043a (" + this.name + "|" + this.ip + ") \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0448\u0451\u043b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443");
    }

    @Override
    public void onMove() {
        ByteBuf expBuf;
        if (this.lastY == -1.0 || this.state == BotFilter.CheckState.FAILED || this.state == BotFilter.CheckState.SUCCESSFULLY || this.onGround) {
            return;
        }
        if (this.state == BotFilter.CheckState.ONLY_CAPTCHA) {
            if (this.lastY != this.y && this.waitingTeleportId == -1) {
                this.resetPosition(true);
            }
            return;
        }
        if (Connector.formatDouble(this.lastY - this.y) != Connector.getSpeed(this.ticks)) {
            if (this.state == BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED) {
                this.changeStateToCaptcha();
            } else {
                this.failed(PacketUtils.KickType.FAILED_FALLING, "Failed position check");
            }
            return;
        }
        if (this.y <= 60.0 && this.state == BotFilter.CheckState.CAPTCHA_POSITION && this.waitingTeleportId == -1) {
            this.resetPosition(false);
        }
        if (this.aticks >= TOTAL_TICKS && this.state != BotFilter.CheckState.CAPTCHA_POSITION) {
            this.completeCheck();
            return;
        }
        if (this.state == BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED && (expBuf = PacketUtils.expPackets.get(this.aticks, this.version)) != null) {
            this.channel.writeAndFlush(expBuf, this.channel.voidPromise());
        }
        ++this.ticks;
        ++this.aticks;
    }

    private void resetPosition(boolean disableFall) {
        if (disableFall) {
            this.channel.write(PacketUtils.getCachedPacket(PacketsPosition.PLAYERABILITIES).get(this.version), this.channel.voidPromise());
        }
        this.waitingTeleportId = 9876;
        this.channel.writeAndFlush(PacketUtils.getCachedPacket(PacketsPosition.PLAYERPOSANDLOOK_CAPTCHA).get(this.version), this.channel.voidPromise());
    }

    @Override
    public void handle(Chat chat) throws Exception {
        if (this.state != BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED) {
            String message = chat.getMessage();
            if (message.length() > 256) {
                this.failed(PacketUtils.KickType.FAILED_CAPTCHA, "Too long message");
                return;
            }
            if (message.replace("/", "").equals(this.captchaAnswer)) {
                this.completeCheck();
            } else if (--this.attemps != 0) {
                ByteBuf buf;
                ByteBuf byteBuf = buf = this.attemps == 2 ? PacketUtils.getCachedPacket(PacketsPosition.CAPTCHA_FAILED_2).get(this.version) : PacketUtils.getCachedPacket(PacketsPosition.CAPTCHA_FAILED_1).get(this.version);
                if (buf != null) {
                    this.channel.write(buf, this.channel.voidPromise());
                }
                this.sendCaptcha();
            } else {
                this.failed(PacketUtils.KickType.FAILED_CAPTCHA, "Failed captcha check");
            }
        }
    }

    @Override
    public void handle(ClientSettings settings) throws Exception {
        this.userConnection.setSettings(settings);
        this.userConnection.setCallSettingsEvent(true);
    }

    @Override
    public void handle(KeepAlive keepAlive) throws Exception {
        if (keepAlive.getRandomId() == (long)PacketUtils.KEEPALIVE_ID) {
            if (this.lastSend == 0L) {
                this.failed(PacketUtils.KickType.PING, "Tried send fake ping");
                return;
            }
            long ping = System.currentTimeMillis() - this.lastSend;
            this.totalping = this.totalping == 9999L ? ping : this.totalping + ping;
            this.lastSend = 0L;
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        if (PluginMessage.SHOULD_RELAY.apply(pluginMessage)) {
            this.userConnection.getPendingConnection().getRelayMessages().add(pluginMessage);
        } else {
            this.userConnection.getDelayedPluginMessages().add(pluginMessage);
        }
    }

    public void sendPing() {
        if (this.lastSend == 0L && this.state != BotFilter.CheckState.FAILED && this.state != BotFilter.CheckState.SUCCESSFULLY) {
            this.lastSend = System.currentTimeMillis();
            ++this.sentPings;
            this.channel.writeAndFlush(PacketUtils.getCachedPacket(PacketsPosition.KEEPALIVE).get(this.version));
        }
    }

    private void sendCaptcha() {
        CachedCaptcha.CaptchaHolder captchaHolder = PacketUtils.captchas.randomCaptcha();
        this.captchaAnswer = captchaHolder.getAnswer();
        this.channel.write(PacketUtils.getCachedPacket(PacketsPosition.SETSLOT_MAP).get(this.version), this.channel.voidPromise());
        captchaHolder.write(this.channel, this.version, true);
    }

    private void changeStateToCaptcha() {
        this.state = BotFilter.CheckState.ONLY_CAPTCHA;
        this.joinTime = System.currentTimeMillis() + 3500L;
        this.channel.write(PacketUtils.getCachedPacket(PacketsPosition.SETEXP_RESET).get(this.version), this.channel.voidPromise());
        PacketUtils.titles[1].writeTitle(this.channel, this.version);
        this.resetPosition(true);
        this.sendCaptcha();
    }

    public String getName() {
        return this.name.toLowerCase();
    }

    public boolean isConnected() {
        return this.userConnection != null && this.channel != null && !this.markDisconnected && this.userConnection.isConnected();
    }

    public void failed(PacketUtils.KickType type, String kickMessage) {
        this.state = BotFilter.CheckState.FAILED;
        PacketUtils.kickPlayer(type, Protocol.GAME, this.userConnection.getCh(), this.version);
        this.markDisconnected = true;
        LOGGER.log(Level.INFO, "(BF) [" + this.name + "|" + this.ip + "] check failed: " + kickMessage);
        if (type != PacketUtils.KickType.BIG_PACKET) {
            FailedUtils.addIpToQueue(this.ip, type);
        }
    }

    public void sendMessage(int index) {
        ByteBuf buf = PacketUtils.getCachedPacket(index).get(this.getVersion());
        if (buf != null) {
            this.getChannel().write(buf, this.getChannel().voidPromise());
        }
    }

    @Override
    public String toString() {
        return "[" + this.name + "|" + this.ip + "] <-> BotFilter";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Connector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public int getVersion() {
        return this.version;
    }

    public UserConnection getUserConnection() {
        return this.userConnection;
    }

    public BotFilter.CheckState getState() {
        return this.state;
    }

    public void setState(BotFilter.CheckState state) {
        this.state = state;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getJoinTime() {
        return this.joinTime;
    }
}

