/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter;

import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import ru.leymooo.botfilter.BotFilter;
import ru.leymooo.botfilter.Connector;
import ru.leymooo.botfilter.caching.PacketUtils;
import ru.leymooo.botfilter.caching.PacketsPosition;
import ru.leymooo.botfilter.config.Settings;
import ru.leymooo.botfilter.utils.FailedUtils;
import ru.leymooo.botfilter.utils.ManyChecksUtils;

public class BotFilterThread {
    private static Thread thread;
    private static final HashSet<String> TO_REMOVE_SET;
    private static BungeeCord bungee;

    public static void start() {
        thread = new Thread(() -> {
            while (BotFilterThread.sleep(1000L)) {
                try {
                    long currTime = System.currentTimeMillis();
                    block9: for (Map.Entry<String, Connector> entryset : bungee.getBotFilter().getConnectedUsersSet().entrySet()) {
                        Connector connector = entryset.getValue();
                        if (!connector.isConnected()) {
                            TO_REMOVE_SET.add(entryset.getKey());
                            continue;
                        }
                        BotFilter.CheckState state = connector.getState();
                        switch (state) {
                            case SUCCESSFULLY: 
                            case FAILED: {
                                TO_REMOVE_SET.add(entryset.getKey());
                                continue block9;
                            }
                        }
                        if (currTime - connector.getJoinTime() >= (long)Settings.IMP.TIME_OUT) {
                            connector.failed(PacketUtils.KickType.TIMED_OUT, state == BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED ? "Too long fall check" : "Captcha not entered");
                            TO_REMOVE_SET.add(entryset.getKey());
                            continue;
                        }
                        if (state == BotFilter.CheckState.CAPTCHA_ON_POSITION_FAILED || state == BotFilter.CheckState.ONLY_POSITION) {
                            connector.sendMessage(PacketsPosition.CHECKING);
                        } else {
                            connector.sendMessage(PacketsPosition.CHECKING_CAPTCHA);
                        }
                        connector.sendPing();
                    }
                }
                catch (Exception e) {
                    bungee.getLogger().log(Level.WARNING, "[BotFilter] \u041d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u0442\u0435 \u0451\u0451 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0443!", e);
                }
                finally {
                    if (TO_REMOVE_SET.isEmpty()) continue;
                    for (String remove : TO_REMOVE_SET) {
                        bungee.getBotFilter().removeConnection(remove, null);
                    }
                    TO_REMOVE_SET.clear();
                }
            }
        }, "BotFilter thread");
        thread.start();
    }

    public static void stop() {
        if (thread != null) {
            thread.interrupt();
        }
    }

    private static boolean sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            return false;
        }
        return true;
    }

    public static void startCleanUpThread() {
        Thread t = new Thread(() -> {
            int counter = 0;
            while (!Thread.interrupted() && BotFilterThread.sleep(5000L)) {
                if ((counter = (int)((byte)(counter + 1))) == 12) {
                    counter = 0;
                    ManyChecksUtils.cleanUP();
                    if (bungee.getBotFilter() != null) {
                        BotFilter botFilter = bungee.getBotFilter();
                        if (botFilter.getServerPingUtils() != null) {
                            botFilter.getServerPingUtils().cleanUP();
                        }
                        if (botFilter.getSql() != null) {
                            botFilter.getSql().tryCleanUP();
                        }
                        if (botFilter.getGeoIp() != null) {
                            botFilter.getGeoIp().tryClenUP();
                        }
                    }
                }
                FailedUtils.flushQueue();
            }
        }, "CleanUp thread");
        t.setDaemon(true);
        t.start();
    }

    static {
        TO_REMOVE_SET = new HashSet();
        bungee = BungeeCord.getInstance();
    }
}

