/*
 * Decompiled with CFR 0.152.
 */
package ru.leymooo.botfilter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import ru.leymooo.botfilter.BotFilter;
import ru.leymooo.botfilter.config.Settings;

public class BotFilterCommand
extends Command {
    public BotFilterCommand() {
        super("botfilter", null, "bf", "antibot", "gg");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof ProxiedPlayer) {
            this.sendStat(sender);
            return;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7r--------------- \u00a7bBotFilter \u00a7cv" + Settings.IMP.BOT_FILTER_VERSION + "\u00a7r-----------------");
            sender.sendMessage("\u00a7r> \u00a7lbotfilter reload \u00a76- \u00a7a\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433");
            sender.sendMessage("\u00a7r> \u00a7lbotfilter stat \u00a76- \u00a7a\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443");
            sender.sendMessage("\u00a7r> \u00a7lbotfilter export \u00a76- \u00a7a\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0438\u0433\u0440\u043e\u043a\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043f\u0440\u043e\u0448\u043b\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443");
            sender.sendMessage("\u00a7r> \u00a7lbotfilter protection on/off \u00a76- \u00a7a\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u043b\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0443\u0447\u043d\u043e\u0439 \u0440\u0435\u0436\u0438\u043c '\u043f\u043e\u0434 \u0430\u0442\u0430\u043a\u043e\u0439'");
            sender.sendMessage("\u00a7r--------------- \u00a7bBotFilter \u00a7r-----------------");
        } else if (args[0].equalsIgnoreCase("reload")) {
            BungeeCord.getInstance().getBotFilter().disable();
            BungeeCord.getInstance().setBotFilter(new BotFilter(false));
            sender.sendMessage("\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        } else if (args[0].equalsIgnoreCase("stat") || args[0].equalsIgnoreCase("stats") || args[0].equalsIgnoreCase("info")) {
            this.sendStat(sender);
        } else if (args[0].equalsIgnoreCase("export")) {
            this.export(sender, args);
            sender.sendMessage("\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        } else if (args[0].equalsIgnoreCase("protection") && args.length >= 2) {
            boolean enable = args[1].equalsIgnoreCase("on");
            BungeeCord.getInstance().getBotFilter().setForceProtectionEnabled(enable);
            sender.sendMessage("\u00a7a\u0417\u0430\u0448\u0438\u0442\u0430 " + (enable ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430" : "\u00a7c\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430"));
        }
    }

    private void sendStat(CommandSender sender) {
        BotFilter botFilter = BungeeCord.getInstance().getBotFilter();
        sender.sendMessage("\u00a7r----------------- \u00a7bBotFilter \u00a7cv" + Settings.IMP.BOT_FILTER_VERSION + " \u00a7r-----------------");
        sender.sendMessage("\u00a7r> \u00a7l\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u0430\u0442\u0430\u043a\u0430: " + (botFilter.isUnderAttack() ? "\u00a7c\u0414\u0430" : "\u00a7a\u041d\u0435\u0442"));
        sender.sendMessage("\u00a7r> \u00a7l\u0411\u043e\u0442\u043e\u0432 \u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435: " + botFilter.getOnlineOnFilter());
        sender.sendMessage("\u00a7r> \u00a7l\u041f\u0440\u043e\u0448\u043b\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443: " + botFilter.getUsersCount());
        sender.sendMessage("\u00a7r> \u00a7l\u0421\u043a\u0430\u0447\u0430\u0442\u044c BotFilter: http://www.rubukkit.org/threads/137038/");
    }

    private void export(CommandSender sender, String[] args) {
        BotFilter botFilter = BungeeCord.getInstance().getBotFilter();
        if (args.length == 1) {
            sender.sendMessage("\u00a7r> \u00a7lbotfilter export [TIME_IN_SECONDS] \u00a76- \u00a7a\u0432\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u0435\u0445, \u043a\u0442\u043e \u043f\u0440\u043e\u0448\u0451\u043b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0437\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f. \u0443\u043a\u0430\u0436\u0438\u0442\u0435 ALL \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0437\u0430 \u0432\u0441\u0451 \u0432\u0440\u0435\u043c\u044f.");
            sender.sendMessage("\u00a7r> \u00a7lbotfilter export [TIME_IN_SECONDS] JOIN \u00a76- \u00a7a\u0432\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u0435\u0445, \u043a\u0442\u043e \u0437\u0430\u0448\u0451\u043b \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440 \u0437\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f (\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u0442 \u0438 \u0442\u0435\u0445 \u043a\u0442\u043e  \u0442\u0430\u043a\u0436\u0435 \u0438 \u043f\u0440\u043e\u0448\u0451\u043b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443).");
            return;
        }
        if (args[1].equalsIgnoreCase("all")) {
            ArrayList<String> out = new ArrayList<String>(botFilter.getUsersCount());
            botFilter.getUserCache().values().forEach(value -> out.add(value.getName() + "|" + value.getIp() + "|" + value.getLastCheck() + "|" + value.getLastJoin()));
            this.exportToFile(out, args.length >= 3 && args[2].equalsIgnoreCase("join"));
            return;
        }
        try {
            int seconds = Integer.parseInt(args[1]);
            boolean join = args.length >= 3 && args[2].equalsIgnoreCase("join");
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, -seconds);
            long until = calendar.getTimeInMillis();
            ArrayList<String> out = new ArrayList<String>(botFilter.getUsersCount());
            botFilter.getUserCache().values().forEach(value -> {
                if (join) {
                    if (value.getLastJoin() >= until) {
                        out.add(value.getName() + "|" + value.getIp() + "|" + value.getLastCheck() + "|" + value.getLastJoin());
                    }
                } else if (value.getLastCheck() >= until) {
                    out.add(value.getName() + "|" + value.getIp() + "|" + value.getLastCheck() + "|" + value.getLastJoin());
                }
            });
            this.exportToFile(out, join);
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e");
        }
    }

    private void exportToFile(List<String> out, boolean join) {
        Path outFile = new File("BotFilter", "whitelist.out." + (join ? "join" : "") + ".txt").toPath();
        try {
            Files.write(outFile, out, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            BungeeCord.getInstance().getLogger().log(Level.WARNING, "[BotFilter] Could not export ip's to file", e);
        }
    }
}

