/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import ru.leymooo.botfilter.utils.FastBadPacketException;

public class MinecraftDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private Protocol protocol;
    private final boolean server;
    private int protocolVersion;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int protocolVersion;
        if (!ctx.channel().isActive()) {
            return;
        }
        if (!this.server && in.readableBytes() == 0) {
            return;
        }
        int originalReaderIndex = in.readerIndex();
        int originalReadableBytes = in.readableBytes();
        int packetId = DefinedPacket.readVarInt(in);
        if (packetId < 0 || packetId > 255) {
            throw new FastBadPacketException("[" + ctx.channel().remoteAddress() + "] <-> MinecraftDecoder received invalid packet id " + packetId);
        }
        Protocol.DirectionData prot = this.server ? this.protocol.TO_SERVER : this.protocol.TO_CLIENT;
        DefinedPacket packet = prot.createPacket(packetId, protocolVersion = this.protocolVersion);
        if (packet != null) {
            packet.read(in, prot.getDirection(), protocolVersion);
            if (in.isReadable()) {
                in.skipBytes(in.readableBytes());
                throw new FastBadPacketException("Did not read all bytes from packet " + packet.getClass() + " " + packetId + " Protocol " + (Object)((Object)this.protocol) + " Direction " + (Object)((Object)prot.getDirection()));
            }
        } else {
            in.skipBytes(in.readableBytes());
        }
        ByteBuf copy = in.copy(originalReaderIndex, originalReadableBytes);
        out.add(new PacketWrapper(packet, copy));
    }

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

