/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.ProtocolConstants;
import ru.leymooo.botfilter.utils.FastException;
import ru.leymooo.botfilter.utils.FastOverflowPacketException;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.Tag;

public abstract class DefinedPacket {
    private static final FastException VARINT_TOO_BIG = new FastException("varint too big");
    private static final FastException ILLEGAL_BUF = new FastException("Buffer is no longer readable");
    public static boolean fix_scoreboards;

    public static void writeString(String s2, ByteBuf buf) {
        if (s2.length() > Short.MAX_VALUE) {
            throw new OverflowPacketException(String.format("Cannot send string longer than Short.MAX_VALUE (got %s characters)", s2.length()));
        }
        byte[] b = s2.getBytes(Charsets.UTF_8);
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static String readString(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > Short.MAX_VALUE) {
            throw new FastOverflowPacketException(String.format("Cannot receive string longer than Short.MAX_VALUE (got " + len + " characters)", new Object[0]));
        }
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, Charsets.UTF_8);
    }

    public static void writeStringAsChatComponent(String s2, ByteBuf buf) {
        if (fix_scoreboards) {
            try {
                if (!ComponentSerializer.getJSON_PARSER().parse(s2).isJsonPrimitive()) {
                    DefinedPacket.writeString(s2, buf);
                    return;
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            DefinedPacket.writeString(ComponentSerializer.toString(TextComponent.fromLegacyText(s2)), buf);
        } else {
            DefinedPacket.writeString(s2, buf);
        }
    }

    public static String readChatComponentAsString(ByteBuf buf) {
        String json = DefinedPacket.readString(buf);
        if (fix_scoreboards) {
            BaseComponent[] components = ComponentSerializer.parse(json);
            return components.length == 0 || components[0] == null ? json : TextComponent.toLegacyText(components);
        }
        return json;
    }

    public static void writeArray(byte[] b, ByteBuf buf) {
        if (b.length > Short.MAX_VALUE) {
            throw new OverflowPacketException(String.format("Cannot send byte array longer than Short.MAX_VALUE (got %s bytes)", b.length));
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static byte[] toArray(ByteBuf buf) {
        byte[] ret = new byte[buf.readableBytes()];
        buf.readBytes(ret);
        return ret;
    }

    public static byte[] readArray(ByteBuf buf) {
        return DefinedPacket.readArray(buf, buf.readableBytes());
    }

    public static byte[] readArray(ByteBuf buf, int limit) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > limit) {
            throw new FastOverflowPacketException(String.format("Cannot receive byte array longer than %s (got %s bytes)", limit, len));
        }
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static int[] readVarIntArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = DefinedPacket.readVarInt(buf);
        }
        return ret;
    }

    public static void writeStringArray(List<String> s2, ByteBuf buf) {
        DefinedPacket.writeVarInt(s2.size(), buf);
        for (String str : s2) {
            DefinedPacket.writeString(str, buf);
        }
    }

    public static List<String> readStringArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        ArrayList<String> ret = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            ret.add(DefinedPacket.readString(buf));
        }
        return ret;
    }

    public static int readVarInt(ByteBuf input) {
        return DefinedPacket.readVarInt(input, 5);
    }

    public static int readVarInt(ByteBuf input, int maxBytes) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= maxBytes) continue;
            throw VARINT_TOO_BIG;
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte(part);
        } while (value != 0);
    }

    public static int readVarShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static void writeUUID(UUID value, ByteBuf output) {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf input) {
        return new UUID(input.readLong(), input.readLong());
    }

    public static Tag readTag(ByteBuf input) {
        Tag tag = NamedTag.read(new DataInputStream(new ByteBufInputStream(input)));
        Preconditions.checkArgument(!tag.isError(), "Error reading tag: %s", (Object)tag.error());
        return tag;
    }

    public static void writeTag(Tag tag, ByteBuf output) {
        try {
            tag.write(new DataOutputStream(new ByteBufOutputStream(output)));
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception writing tag", ex);
        }
    }

    public void read(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement read method");
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf);
    }

    public void write(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement write method");
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf);
    }

    public abstract void handle(AbstractPacketHandler var1) throws Exception;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

