/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.conf;

import com.google.common.base.Preconditions;
import gnu.trove.map.TMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyConfig;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.util.CaseInsensitiveMap;
import net.md_5.bungee.util.CaseInsensitiveSet;

public class Configuration
implements ProxyConfig {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private TMap<String, ServerInfo> servers;
    private boolean onlineMode = true;
    private boolean logCommands;
    private boolean logPings = true;
    private int remotePingCache = -1;
    private int playerLimit = -1;
    private Collection<String> disabledCommands;
    private int serverConnectTimeout = 5000;
    private int remotePingTimeout = 5000;
    private int throttle = 4000;
    private int throttleLimit = 3;
    private boolean ipForward;
    private Favicon favicon;
    private int compressionThreshold = 256;
    private boolean preventProxyConnections;
    private boolean forgeSupport;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        adapter.load();
        File fav = new File("server-icon.png");
        if (fav.exists()) {
            try {
                this.favicon = Favicon.create(ImageIO.read(fav));
            }
            catch (IOException | IllegalArgumentException ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load server icon", ex);
            }
        }
        this.listeners = adapter.getListeners();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        this.onlineMode = adapter.getBoolean("online_mode", this.onlineMode);
        this.logCommands = adapter.getBoolean("log_commands", this.logCommands);
        this.logPings = adapter.getBoolean("log_pings", this.logPings);
        this.remotePingCache = adapter.getInt("remote_ping_cache", this.remotePingCache);
        this.playerLimit = adapter.getInt("player_limit", this.playerLimit);
        this.serverConnectTimeout = adapter.getInt("server_connect_timeout", this.serverConnectTimeout);
        this.remotePingTimeout = adapter.getInt("remote_ping_timeout", this.remotePingTimeout);
        this.throttle = adapter.getInt("connection_throttle", this.throttle);
        this.throttleLimit = adapter.getInt("connection_throttle_limit", this.throttleLimit);
        this.ipForward = adapter.getBoolean("ip_forward", this.ipForward);
        this.compressionThreshold = adapter.getInt("network_compression_threshold", this.compressionThreshold);
        this.preventProxyConnections = adapter.getBoolean("prevent_proxy_connections", this.preventProxyConnections);
        this.forgeSupport = adapter.getBoolean("forge_support", this.forgeSupport);
        this.disabledCommands = new CaseInsensitiveSet(adapter.getList("disabled_commands", Arrays.asList("disabledcommandhere")));
        this.disabledCommands.remove("bungee");
        this.disabledCommands.remove("botfilter");
        Preconditions.checkArgument(this.listeners != null && !this.listeners.isEmpty(), "No listeners defined.");
        this.loadServers(adapter, false);
        for (ListenerInfo listener : this.listeners) {
            for (int i = 0; i < listener.getServerPriority().size(); ++i) {
                String server = listener.getServerPriority().get(i);
                Preconditions.checkArgument(this.servers.containsKey(server), "Server %s (priority %s) is not defined", (Object)server, i);
            }
            for (String server : listener.getForcedHosts().values()) {
                if (this.servers.containsKey(server)) continue;
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Forced host server {0} is not defined", server);
            }
        }
    }

    public void loadServers(ConfigurationAdapter adapter, boolean load) {
        Map<String, ServerInfo> newServers;
        if (load) {
            adapter.load();
        }
        Preconditions.checkArgument((newServers = adapter.getServers()) != null && !newServers.isEmpty(), "No servers defined");
        if (this.servers == null) {
            this.servers = new CaseInsensitiveMap<ServerInfo>(newServers);
        } else {
            HashSet toRemove = new HashSet();
            this.servers.values().stream().filter(oldServer -> !newServers.containsKey(oldServer.getName()) || !((ServerInfo)newServers.get(oldServer.getName())).equals(oldServer)).forEach(server -> {
                toRemove.add(server.getName());
                server.getPlayers().forEach(p -> p.disconnect(BungeeCord.getInstance().getTranslation("server_went_down", new Object[0])));
            });
            toRemove.forEach(s2 -> {
                ServerInfo cfr_ignored_0 = (ServerInfo)this.servers.remove(s2);
            });
            for (Map.Entry<String, ServerInfo> newServer : newServers.entrySet()) {
                if (this.servers.containsValue(newServer.getValue())) continue;
                this.servers.put(newServer.getKey(), newServer.getValue());
            }
        }
    }

    @Override
    @Deprecated
    public String getFavicon() {
        return this.getFaviconObject().getEncoded();
    }

    @Override
    public Favicon getFaviconObject() {
        return this.favicon;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public TMap<String, ServerInfo> getServers() {
        return this.servers;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public boolean isLogCommands() {
        return this.logCommands;
    }

    public boolean isLogPings() {
        return this.logPings;
    }

    @Override
    public int getRemotePingCache() {
        return this.remotePingCache;
    }

    @Override
    public int getPlayerLimit() {
        return this.playerLimit;
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.disabledCommands;
    }

    @Override
    public int getServerConnectTimeout() {
        return this.serverConnectTimeout;
    }

    @Override
    public int getRemotePingTimeout() {
        return this.remotePingTimeout;
    }

    @Override
    public int getThrottle() {
        return this.throttle;
    }

    public int getThrottleLimit() {
        return this.throttleLimit;
    }

    @Override
    public boolean isIpForward() {
        return this.ipForward;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public boolean isPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public boolean isForgeSupport() {
        return this.forgeSupport;
    }
}

