/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.PriorityQueue;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int OFFSET_BIT_LENGTH = 15;
    private static final int SIZE_BIT_LENGTH = 15;
    private static final int INUSED_BIT_LENGTH = 1;
    private static final int SUBPAGE_BIT_LENGTH = 1;
    private static final int BITMAP_IDX_BIT_LENGTH = 32;
    static final int IS_SUBPAGE_SHIFT = 32;
    static final int IS_USED_SHIFT = 33;
    static final int SIZE_SHIFT = 34;
    static final int RUN_OFFSET_SHIFT = 49;
    final PoolArena<T> arena;
    final T memory;
    final boolean unpooled;
    final int offset;
    private final IntObjectMap<Long> runsAvailMap;
    private final PriorityQueue<Long>[] runsAvail;
    private final PoolSubpage<T>[] subpages;
    private final int pageSize;
    private final int pageShifts;
    private final int chunkSize;
    private final Deque<ByteBuffer> cachedNioBuffers;
    int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> arena, T memory, int pageSize, int pageShifts, int chunkSize, int maxPageIdx, int offset) {
        this.unpooled = false;
        this.arena = arena;
        this.memory = memory;
        this.pageSize = pageSize;
        this.pageShifts = pageShifts;
        this.chunkSize = chunkSize;
        this.offset = offset;
        this.freeBytes = chunkSize;
        this.runsAvail = PoolChunk.newRunsAvailqueueArray(maxPageIdx);
        this.runsAvailMap = new IntObjectHashMap<Long>();
        this.subpages = new PoolSubpage[chunkSize >> pageShifts];
        int pages = chunkSize >> pageShifts;
        long initHandle = (long)pages << 34;
        this.insertAvailRun(0, pages, initHandle);
        this.cachedNioBuffers = new ArrayDeque<ByteBuffer>(8);
    }

    PoolChunk(PoolArena<T> arena, T memory, int size, int offset) {
        this.unpooled = true;
        this.arena = arena;
        this.memory = memory;
        this.offset = offset;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.runsAvailMap = null;
        this.runsAvail = null;
        this.subpages = null;
        this.chunkSize = size;
        this.cachedNioBuffers = null;
    }

    private static PriorityQueue<Long>[] newRunsAvailqueueArray(int size) {
        PriorityQueue[] queueArray = new PriorityQueue[size];
        for (int i = 0; i < queueArray.length; ++i) {
            queueArray[i] = new PriorityQueue();
        }
        return queueArray;
    }

    private void insertAvailRun(int runOffset, int pages, Long handle) {
        int pageIdxFloor = this.arena.pages2pageIdxFloor(pages);
        PriorityQueue<Long> queue = this.runsAvail[pageIdxFloor];
        queue.offer(handle);
        this.insertAvailRun0(runOffset, handle);
        if (pages > 1) {
            this.insertAvailRun0(PoolChunk.lastPage(runOffset, pages), handle);
        }
    }

    private void insertAvailRun0(int runOffset, Long handle) {
        Long pre = this.runsAvailMap.put(runOffset, handle);
        assert (pre == null);
    }

    private void removeAvailRun(long handle) {
        int pageIdxFloor = this.arena.pages2pageIdxFloor(PoolChunk.runPages(handle));
        PriorityQueue<Long> queue = this.runsAvail[pageIdxFloor];
        this.removeAvailRun(queue, handle);
    }

    private void removeAvailRun(PriorityQueue<Long> queue, long handle) {
        queue.remove(handle);
        int runOffset = PoolChunk.runOffset(handle);
        int pages = PoolChunk.runPages(handle);
        this.runsAvailMap.remove(runOffset);
        if (pages > 1) {
            this.runsAvailMap.remove(PoolChunk.lastPage(runOffset, pages));
        }
    }

    private static int lastPage(int runOffset, int pages) {
        return runOffset + pages - 1;
    }

    private Long getAvailRunByOffset(int runOffset) {
        return this.runsAvailMap.get(runOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int usage() {
        int freeBytes;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            freeBytes = this.freeBytes;
        }
        return this.usage(freeBytes);
    }

    private int usage(int freeBytes) {
        if (freeBytes == 0) {
            return 100;
        }
        int freePercentage = (int)((long)freeBytes * 100L / (long)this.chunkSize);
        if (freePercentage == 0) {
            return 99;
        }
        return 100 - freePercentage;
    }

    boolean allocate(PooledByteBuf<T> buf, int reqCapacity, int sizeIdx, PoolThreadCache cache) {
        long handle;
        if (sizeIdx <= this.arena.smallMaxSizeIdx) {
            handle = this.allocateSubpage(sizeIdx);
            if (handle < 0L) {
                return false;
            }
            assert (PoolChunk.isSubpage(handle));
        } else {
            int runSize = this.arena.sizeIdx2size(sizeIdx);
            handle = this.allocateRun(runSize);
            if (handle < 0L) {
                return false;
            }
        }
        ByteBuffer nioBuffer = this.cachedNioBuffers != null ? this.cachedNioBuffers.pollLast() : null;
        this.initBuf(buf, nioBuffer, handle, reqCapacity, cache);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateRun(int runSize) {
        int pages = runSize >> this.pageShifts;
        int pageIdx = this.arena.pages2pageIdx(pages);
        PriorityQueue<Long>[] priorityQueueArray = this.runsAvail;
        synchronized (this.runsAvail) {
            int queueIdx = this.runFirstBestFit(pageIdx);
            if (queueIdx == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1L;
            }
            PriorityQueue<Long> queue = this.runsAvail[queueIdx];
            long handle = queue.poll();
            assert (!PoolChunk.isUsed(handle));
            this.removeAvailRun(queue, handle);
            if (handle != -1L) {
                handle = this.splitLargeRun(handle, pages);
            }
            this.freeBytes -= PoolChunk.runSize(this.pageShifts, handle);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return handle;
        }
    }

    private int calculateRunSize(int sizeIdx) {
        int nElements;
        int maxElements = 1 << this.pageShifts - 4;
        int runSize = 0;
        int elemSize = this.arena.sizeIdx2size(sizeIdx);
        while ((nElements = (runSize += this.pageSize) / elemSize) < maxElements && runSize != nElements * elemSize) {
        }
        while (nElements > maxElements) {
            nElements = (runSize -= this.pageSize) / elemSize;
        }
        assert (nElements > 0);
        assert (runSize <= this.chunkSize);
        assert (runSize >= elemSize);
        return runSize;
    }

    private int runFirstBestFit(int pageIdx) {
        if (this.freeBytes == this.chunkSize) {
            return this.arena.nPSizes - 1;
        }
        for (int i = pageIdx; i < this.arena.nPSizes; ++i) {
            PriorityQueue<Long> queue = this.runsAvail[i];
            if (queue == null || queue.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private long splitLargeRun(long handle, int needPages) {
        assert (needPages > 0);
        int totalPages = PoolChunk.runPages(handle);
        assert (needPages <= totalPages);
        int remPages = totalPages - needPages;
        if (remPages > 0) {
            int runOffset = PoolChunk.runOffset(handle);
            int availOffset = runOffset + needPages;
            long availRun = PoolChunk.toRunHandle(availOffset, remPages, 0);
            this.insertAvailRun(availOffset, remPages, availRun);
            return PoolChunk.toRunHandle(runOffset, needPages, 1);
        }
        return handle |= 0x200000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateSubpage(int sizeIdx) {
        PoolSubpage<T> head;
        PoolSubpage<T> poolSubpage = head = this.arena.findSubpagePoolHead(sizeIdx);
        synchronized (poolSubpage) {
            int runSize = this.calculateRunSize(sizeIdx);
            long runHandle = this.allocateRun(runSize);
            if (runHandle < 0L) {
                return -1L;
            }
            int runOffset = PoolChunk.runOffset(runHandle);
            int elemSize = this.arena.sizeIdx2size(sizeIdx);
            PoolSubpage<T> subpage = new PoolSubpage<T>(head, this, this.pageShifts, runOffset, PoolChunk.runSize(this.pageShifts, runHandle), elemSize);
            this.subpages[runOffset] = subpage;
            return subpage.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long handle, int normCapacity, ByteBuffer nioBuffer) {
        if (PoolChunk.isSubpage(handle)) {
            int sizeIdx = this.arena.size2SizeIdx(normCapacity);
            PoolSubpage<T> head = this.arena.findSubpagePoolHead(sizeIdx);
            PoolSubpage<T> subpage = this.subpages[PoolChunk.runOffset(handle)];
            assert (subpage != null && subpage.doNotDestroy);
            PoolSubpage<T> poolSubpage = head;
            synchronized (poolSubpage) {
                if (subpage.free(head, PoolChunk.bitmapIdx(handle))) {
                    return;
                }
            }
        }
        int pages = PoolChunk.runPages(handle);
        PriorityQueue<Long>[] priorityQueueArray = this.runsAvail;
        synchronized (this.runsAvail) {
            long finalRun = this.collapseRuns(handle);
            finalRun &= 0xFFFFFFFDFFFFFFFFL;
            this.insertAvailRun(PoolChunk.runOffset(finalRun &= 0xFFFFFFFEFFFFFFFFL), PoolChunk.runPages(finalRun), finalRun);
            this.freeBytes += pages << this.pageShifts;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (nioBuffer != null && this.cachedNioBuffers != null && this.cachedNioBuffers.size() < PooledByteBufAllocator.DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK) {
                this.cachedNioBuffers.offer(nioBuffer);
            }
            return;
        }
    }

    private long collapseRuns(long handle) {
        return this.collapseNext(this.collapsePast(handle));
    }

    private long collapsePast(long handle) {
        while (true) {
            int runOffset = PoolChunk.runOffset(handle);
            int runPages = PoolChunk.runPages(handle);
            Long pastRun = this.getAvailRunByOffset(runOffset - 1);
            if (pastRun == null) {
                return handle;
            }
            int pastOffset = PoolChunk.runOffset(pastRun);
            int pastPages = PoolChunk.runPages(pastRun);
            if (pastRun == handle || pastOffset + pastPages != runOffset) break;
            this.removeAvailRun(pastRun);
            handle = PoolChunk.toRunHandle(pastOffset, pastPages + runPages, 0);
        }
        return handle;
    }

    private long collapseNext(long handle) {
        while (true) {
            int runPages;
            int runOffset;
            Long nextRun;
            if ((nextRun = this.getAvailRunByOffset((runOffset = PoolChunk.runOffset(handle)) + (runPages = PoolChunk.runPages(handle)))) == null) {
                return handle;
            }
            int nextOffset = PoolChunk.runOffset(nextRun);
            int nextPages = PoolChunk.runPages(nextRun);
            if (nextRun == handle || runOffset + runPages != nextOffset) break;
            this.removeAvailRun(nextRun);
            handle = PoolChunk.toRunHandle(runOffset, runPages + nextPages, 0);
        }
        return handle;
    }

    private static long toRunHandle(int runOffset, int runPages, int inUsed) {
        return (long)runOffset << 49 | (long)runPages << 34 | (long)inUsed << 33;
    }

    void initBuf(PooledByteBuf<T> buf, ByteBuffer nioBuffer, long handle, int reqCapacity, PoolThreadCache threadCache) {
        if (PoolChunk.isRun(handle)) {
            buf.init(this, nioBuffer, handle, PoolChunk.runOffset(handle) << this.pageShifts, reqCapacity, PoolChunk.runSize(this.pageShifts, handle), this.arena.parent.threadCache());
        } else {
            this.initBufWithSubpage(buf, nioBuffer, handle, reqCapacity, threadCache);
        }
    }

    void initBufWithSubpage(PooledByteBuf<T> buf, ByteBuffer nioBuffer, long handle, int reqCapacity, PoolThreadCache threadCache) {
        int runOffset = PoolChunk.runOffset(handle);
        int bitmapIdx = PoolChunk.bitmapIdx(handle);
        PoolSubpage<T> s2 = this.subpages[runOffset];
        assert (s2.doNotDestroy);
        assert (reqCapacity <= s2.elemSize);
        buf.init(this, nioBuffer, handle, (runOffset << this.pageShifts) + bitmapIdx * s2.elemSize + this.offset, reqCapacity, s2.elemSize, threadCache);
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeBytes() {
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            return this.freeBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int freeBytes;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            freeBytes = this.freeBytes;
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(freeBytes) + "%, " + (this.chunkSize - freeBytes) + '/' + this.chunkSize + ')';
    }

    void destroy() {
        this.arena.destroyChunk(this);
    }

    static int runOffset(long handle) {
        return (int)(handle >> 49);
    }

    static int runSize(int pageShifts, long handle) {
        return PoolChunk.runPages(handle) << pageShifts;
    }

    static int runPages(long handle) {
        return (int)(handle >> 34 & 0x7FFFL);
    }

    static boolean isUsed(long handle) {
        return (handle >> 33 & 1L) == 1L;
    }

    static boolean isRun(long handle) {
        return !PoolChunk.isSubpage(handle);
    }

    static boolean isSubpage(long handle) {
        return (handle >> 32 & 1L) == 1L;
    }

    static int bitmapIdx(long handle) {
        return (int)handle;
    }
}

