#version 150

#moj_import <fog.glsl>
#moj_import <light.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

uniform mat3 IViewRotMat;
uniform mat4 ProjMat;
uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;
in vec4 normal;

in float isBobber;
in vec3 viewPos;
in vec3 Pos;

out vec4 fragColor;

// intersections by Inigo Quilez
// The MIT License
// Copyright © 2014 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// https://www.youtube.com/c/InigoQuilez
// https://iquilezles.org/
// https://iquilezles.org/articles/intersectors/
float boxIntersection( in vec3 ro, in vec3 rd, vec3 boxSize, out vec3 outNormal ) 
{
    vec3 m = 1.0 / rd; // can precompute if traversing a set of aligned boxes
    vec3 n = m * ro;   // can precompute if traversing a set of aligned boxes
    vec3 k = abs(m) * boxSize;
    vec3 t1 = -n - k;
    vec3 t2 = -n + k;
    float tN = max(max(t1.x, t1.y), t1.z);
    float tF = min(min(t2.x, t2.y), t2.z);
    if(tN > tF || tF < 0.0) return -1.0; // no intersection
    outNormal = sign(rd) * step(t1.yzx, t1.xyz) * step(t1.zxy, t1.xyz);
    return tN;
}

void main() {
    vec4 color = vec4(0);
    gl_FragDepth = gl_FragCoord.z;
    if (isBobber > 0) {
      vec3 dir = normalize(-viewPos.xyz);
      vec3 worldDir = IViewRotMat*dir;
      
      vec3 stringNormal = vec3(0.0);
      float stringIntersect = max(
        boxIntersection(Pos - vec3(0.00, -0.125, 0.0), worldDir, vec3(0.03125, 0.03125, 0.0), stringNormal),
        boxIntersection(Pos - vec3(0.00, -0.125, 0.0), worldDir, vec3(0.0, 0.03125, 0.03125), stringNormal));
      vec3 hookNormal = vec3(0.0);
      float hookIntersect = boxIntersection(Pos - vec3(-0.03125, 0.2, 0.0), worldDir, vec3(0.125, 0.125, 0.0), hookNormal);
      vec4 hookColor = vec4(0.0);
      if (hookIntersect > 0.0){
        vec2 txCoord = (Pos.xyz - vec3(-0.03125, 0.2, 0.0) + hookIntersect * worldDir).xy * 8.0;
        hookColor = texture(Sampler0, vec2(0.5, 0.75) + txCoord * vec2(0.25));
      }
      
      vec3 bobberNormal = vec3(0);
      vec4 bobberColor = vec4(0);
      float bobberIntersect = boxIntersection(Pos, worldDir, vec3(0.09375), bobberNormal);
      if (bobberIntersect > 0.0) {
        vec2 txCoord = (Pos.xyz + bobberNormal * 0.001  + bobberIntersect  * worldDir).xy * 10.66666666;
        bobberColor = texture(Sampler0, vec2(0.5625, 0.3125) + txCoord * vec2(0.1875));
        bobberColor = minecraft_mix_light(Light0_Direction, Light1_Direction, bobberNormal * IViewRotMat, bobberColor);
      }
      float depth = max(max(hookIntersect * hookColor.a * (1.0 - bobberColor.a), bobberIntersect), stringIntersect);
      if (depth <= 0) {
        discard;
      }
      
      color = float(stringIntersect < 0.0 || stringIntersect > bobberIntersect) * mix(bobberColor, hookColor, float(hookIntersect < bobberIntersect * hookColor.a && hookIntersect > 0));
      color *= ColorModulator;
      
      vec4 clipPos = ProjMat * vec4(-dir * depth, 1);
      gl_FragDepth = clipPos.z / clipPos.w * 0.5 + 0.5;
    } else {
      color = texture(Sampler0, texCoord0);
      if (color.a < 0.1) {
          discard;
      }
      color *= vertexColor * ColorModulator;
    }
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    color *= lightMapColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
