/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.upload;

import com.google.gson.Gson;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.upload.UploadToCrashyError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPOutputStream;

public class CrashyUpload {
    private static final Path CRASH_CODES_PATH = NotEnoughCrashes.DIRECTORY.resolve("Uploaded Crash logs.txt");
    private static final boolean localTesting = false;

    public static CompletableFuture<String> uploadToCrashy(String text) throws IOException {
        try {
            String prefix = "https://europe-west1-crashy-9dd87.cloudfunctions.net";
            return CrashyUpload.java11PostAsync(prefix + "/uploadCrash", CrashyUpload.gzip(text)).thenApply(response -> {
                int statusCode = response.statusCode();
                String responseBody = (String)response.body();
                return switch (statusCode) {
                    case 200 -> {
                        UploadCrashSuccess responseObject = (UploadCrashSuccess)new Gson().fromJson(responseBody, UploadCrashSuccess.class);
                        try {
                            CrashyUpload.rememberCrashCode(responseObject.crashId, responseObject.key);
                        }
                        catch (IOException e) {
                            NotEnoughCrashes.getLogger().error("Could not remember crash code when uploading crash " + responseObject.crashId, (Throwable)e);
                        }
                        yield responseObject.crashUrl;
                    }
                    case 400 -> throw new UploadToCrashyError.InvalidCrash();
                    case 413 -> throw new UploadToCrashyError.TooLarge();
                    default -> throw new IllegalStateException("Unexpected status code when uploading to crashy: " + statusCode + " message: " + responseBody);
                };
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String uploadToCrashySync(String text) throws IOException, ExecutionException, InterruptedException {
        return CrashyUpload.uploadToCrashy(text).get();
    }

    private static CompletableFuture<HttpResponse<String>> java11PostAsync(String url, byte[] body) throws InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).setHeader("content-type", "application/gzip").POST(HttpRequest.BodyPublishers.ofByteArray(body)).build();
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    private static byte[] gzip(String string) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                gzos.write(string.getBytes(StandardCharsets.UTF_8));
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static void rememberCrashCode(String id, String code) throws IOException {
        NotEnoughCrashes.ensureDirectoryExists();
        String oldCodes = Files.exists(CRASH_CODES_PATH, new LinkOption[0]) ? Files.readString(CRASH_CODES_PATH) : "";
        Files.writeString(CRASH_CODES_PATH, (CharSequence)(oldCodes + id + ": " + code + "\n"), new OpenOption[0]);
    }

    static class UploadCrashSuccess {
        String crashId;
        String key;
        String crashUrl;

        UploadCrashSuccess() {
        }
    }
}

