/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.gui.util.TextWidget;
import fudge.notenoughcrashes.gui.util.Widget;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.upload.CrashyUpload;
import fudge.notenoughcrashes.upload.LegacyCrashLogUpload;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_128;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public abstract class ProblemScreen
extends class_437 {
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader", "quilt_loader", "forge", "notenoughcrashes"));
    private static final int GREEN = 65280;
    private static final class_2561 uploadToCrashyText = NecLocalization.translatedText("notenoughcrashes.gui.uploadToCrashy").method_27661().method_10862(class_2583.field_24360.method_36139(65280));
    private static final class_2561 uploadToCrashyLoadingText = NecLocalization.translatedText("notenoughcrashes.gui.loadingCrashyUpload");
    private List<Widget> widgets = new ArrayList<Widget>();
    protected class_128 report;
    private String uploadedCrashLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;
    private String crashyLink = null;

    protected void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public abstract ProblemScreen construct(class_128 var1);

    protected ProblemScreen(class_128 report) {
        super(class_2561.method_30163((String)""));
        this.report = report;
    }

    private class_2561 getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.report);
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.id()));
        if (suspectedMods.isEmpty()) {
            return NecLocalization.translatedText("notenoughcrashes.crashscreen.noModsErrored");
        }
        return (class_2561)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::name)).map(mod -> {
            String issuesPage = mod.issuesPage();
            class_5250 modText = class_2561.method_43470((String)mod.name());
            if (issuesPage != null) {
                modText.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, issuesPage)));
            }
            return modText;
        }).reduce((existing, next) -> existing.method_10852(class_2561.method_30163((String)", ")).method_10852((class_2561)next)).get();
    }

    private void addSuspectedModsWidget() {
        this.addWidget(new TextWidget(this.getSuspectedModsText(), 0xE0E000, this.field_22793, this.field_22789 / 2, this.y + 29));
    }

    private void handleLegacyLinkClick(class_4185 buttonWidget) {
        try {
            if (this.uploadedCrashLink == null) {
                this.uploadedCrashLink = LegacyCrashLogUpload.upload(this.report.method_568());
            }
            class_310.method_1551().method_1507((class_437)new class_407(b -> {
                if (b) {
                    class_156.method_668().method_670(this.uploadedCrashLink);
                }
                class_310.method_1551().method_1507((class_437)this.construct(this.report));
            }, this.uploadedCrashLink, true));
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception when crash menu button clicked:", e);
            buttonWidget.method_25355(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.field_22763 = false;
        }
    }

    private void handleCrashyUploadClick(class_4185 buttonWidget) {
        try {
            if (this.crashyLink == null) {
                buttonWidget.field_22763 = false;
                buttonWidget.method_25355(uploadToCrashyLoadingText);
                CrashyUpload.uploadToCrashy(this.report.method_568()).thenAccept(link -> {
                    this.crashyLink = link;
                    buttonWidget.field_22763 = true;
                    buttonWidget.method_25355(uploadToCrashyText);
                    class_156.method_668().method_670(this.crashyLink);
                });
            } else {
                class_156.method_668().method_670(this.crashyLink);
            }
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception uploading to crashy", e);
            buttonWidget.method_25355(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.field_22763 = false;
        }
    }

    public void method_25426() {
        this.widgets = new ArrayList<Widget>();
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155 + 160, this.field_22790 / 4 + 132 + 12, 150, 20, NecLocalization.translatedText("notenoughcrashes.gui.getLink"), this::handleLegacyLinkClick));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155 + 160, this.field_22790 / 4 + 108 + 12, 150, 20, uploadToCrashyText, this::handleCrashyUploadClick));
        this.x = this.field_22789 / 2 - 155;
        this.y = this.field_22790 / 4;
        this.addSuspectedModsWidget();
    }

    public boolean method_25402(double x, double y, int int_1) {
        File file;
        for (Widget widget : this.widgets) {
            widget.onClick(x, y);
        }
        if (x >= (double)this.xLeft && x <= (double)this.xRight && y >= (double)this.yTop && y <= (double)this.yBottom && (file = this.report.method_572()) != null) {
            class_156.method_668().method_672(file);
        }
        return super.method_25402(x, y, int_1);
    }

    public boolean method_25422() {
        return false;
    }

    protected void drawFileNameString(class_4587 matrixStack, int y) {
        String fileNameString = this.report.method_572() != null ? "\u00a7n" + this.report.method_572().getName() : NecLocalization.localize("notenoughcrashes.crashscreen.reportSaveFailed");
        int stLen = this.field_22793.method_1727(fileNameString);
        this.xLeft = this.field_22789 / 2 - stLen / 2;
        this.xRight = this.field_22789 / 2 + stLen / 2;
        ProblemScreen.method_25303((class_4587)matrixStack, (class_327)this.field_22793, (String)fileNameString, (int)this.xLeft, (int)(y += 11), (int)65280);
        this.yTop = y;
        this.yBottom = y + 10;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.draw(matrixStack);
        }
        super.method_25394(matrixStack, mouseX, mouseY, delta);
    }
}

