/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.impl.utils;

import dev.isxander.yacl.api.utils.Dimension;

public class DimensionIntegerImpl
implements Dimension<Integer> {
    private int x;
    private int y;
    private int width;
    private int height;

    public DimensionIntegerImpl(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public Integer x() {
        return this.x;
    }

    @Override
    public Integer y() {
        return this.y;
    }

    @Override
    public Integer width() {
        return this.width;
    }

    @Override
    public Integer height() {
        return this.height;
    }

    @Override
    public Integer xLimit() {
        return this.x + this.width;
    }

    @Override
    public Integer yLimit() {
        return this.y + this.height;
    }

    @Override
    public Integer centerX() {
        return this.x + this.width / 2;
    }

    @Override
    public Integer centerY() {
        return this.y + this.height / 2;
    }

    @Override
    public boolean isPointInside(Integer x, Integer y) {
        return x >= this.x() && x <= this.xLimit() && y >= this.y() && y <= this.yLimit();
    }

    @Override
    public Dimension<Integer> clone() {
        return new DimensionIntegerImpl(this.x, this.y, this.width, this.height);
    }

    @Override
    public Dimension<Integer> setX(Integer x) {
        this.x = x;
        return this;
    }

    @Override
    public Dimension<Integer> setY(Integer y) {
        this.y = y;
        return this;
    }

    @Override
    public Dimension<Integer> setWidth(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public Dimension<Integer> setHeight(Integer height) {
        this.height = height;
        return this;
    }

    @Override
    public Dimension<Integer> withX(Integer x) {
        return this.clone().setX(x);
    }

    @Override
    public Dimension<Integer> withY(Integer y) {
        return this.clone().setY(y);
    }

    @Override
    public Dimension<Integer> withWidth(Integer width) {
        return this.clone().withWidth(width);
    }

    @Override
    public Dimension<Integer> withHeight(Integer height) {
        return this.clone().withHeight(height);
    }

    @Override
    public Dimension<Integer> move(Integer x, Integer y) {
        this.x += x.intValue();
        this.y += y.intValue();
        return this;
    }

    @Override
    public Dimension<Integer> expand(Integer width, Integer height) {
        this.width += width.intValue();
        this.height += height.intValue();
        return this;
    }

    @Override
    public Dimension<Integer> moved(Integer x, Integer y) {
        return this.clone().move(x, y);
    }

    @Override
    public Dimension<Integer> expanded(Integer width, Integer height) {
        return this.clone().expand(width, height);
    }
}

