/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_3222;
import su.plo.voice.common.entities.MutedEntity;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.tcp.ClientConnectedPacket;
import su.plo.voice.common.packets.tcp.ClientsListPacket;
import su.plo.voice.common.packets.udp.AuthPacket;
import su.plo.voice.common.packets.udp.AuthPacketAck;
import su.plo.voice.common.packets.udp.PacketUDP;
import su.plo.voice.common.packets.udp.PingPacket;
import su.plo.voice.common.packets.udp.VoiceClientPacket;
import su.plo.voice.common.packets.udp.VoiceEndClientPacket;
import su.plo.voice.common.packets.udp.VoiceEndServerPacket;
import su.plo.voice.common.packets.udp.VoiceServerPacket;
import su.plo.voice.server.PlayerManager;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.config.ServerMuted;
import su.plo.voice.server.network.ServerNetworkHandler;
import su.plo.voice.server.socket.SocketClientUDP;
import su.plo.voice.server.socket.SocketServerUDP;

public class SocketServerUDPQueue
extends Thread {
    public LinkedBlockingQueue<PacketUDP> queue = new LinkedBlockingQueue();

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Packet serverPacket;
                SocketClientUDP client;
                Object clients;
                class_3222 player;
                this.keepAlive();
                PacketUDP message = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                if (message == null || message.getPacket() == null || System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) continue;
                Packet packet = message.getPacket();
                if (packet instanceof AuthPacket) {
                    AuthPacket packet2 = (AuthPacket)packet;
                    player = new AtomicReference();
                    ServerNetworkHandler.playerToken.forEach((arg_0, arg_1) -> SocketServerUDPQueue.lambda$run$0(packet2, (AtomicReference)player, arg_0, arg_1));
                    if (player.get() != null) {
                        ServerNetworkHandler.playerToken.remove(((class_3222)player.get()).method_5667());
                        String type = VoiceServer.getNetwork().isVanillaPlayer((class_3222)player.get()) ? "forge" : "fabric";
                        SocketClientUDP sock = new SocketClientUDP(((class_3222)player.get()).method_5667(), type, message.getAddress(), message.getPort());
                        if (!SocketServerUDP.clients.containsKey(((class_3222)player.get()).method_5667())) {
                            SocketServerUDP.clients.put(((class_3222)player.get()).method_5667(), sock);
                            clients = new ArrayList();
                            SocketServerUDP.clients.forEach((arg_0, arg_1) -> SocketServerUDPQueue.lambda$run$1((List)clients, arg_0, arg_1));
                            ArrayList<MutedEntity> muted = new ArrayList<MutedEntity>();
                            Iterator iterator = clients.iterator();
                            while (iterator.hasNext()) {
                                UUID client2 = (UUID)iterator.next();
                                class_3222 clientPlayer = VoiceServer.getServer().method_3760().method_14602(client2);
                                if (clientPlayer == null) continue;
                                ServerMuted serverPlayerMuted = VoiceServer.getMuted().get(client2);
                                MutedEntity playerMuted = null;
                                if (serverPlayerMuted != null) {
                                    playerMuted = new MutedEntity(serverPlayerMuted.getUuid(), serverPlayerMuted.getTo());
                                }
                                if (!VoiceServer.getPlayerManager().hasPermission(clientPlayer.method_5667(), "voice.speak")) {
                                    playerMuted = new MutedEntity(client2, 0L);
                                }
                                if (playerMuted == null) continue;
                                muted.add(playerMuted);
                            }
                            VoiceServer.getMuted().forEach((uuid, m) -> muted.add(new MutedEntity(m.getUuid(), m.getTo())));
                            ServerNetworkHandler.sendTo(new ClientsListPacket((List<UUID>)clients, muted), (class_3222)player.get());
                            ServerMuted serverPlayerMuted = VoiceServer.getMuted().get(UUID.randomUUID());
                            MutedEntity playerMuted = null;
                            if (serverPlayerMuted != null) {
                                playerMuted = new MutedEntity(serverPlayerMuted.getUuid(), serverPlayerMuted.getTo());
                            }
                            if (!VoiceServer.getPlayerManager().hasPermission(((class_3222)player.get()).method_5667(), "voice.speak")) {
                                playerMuted = new MutedEntity(((class_3222)player.get()).method_5667(), 0L);
                            }
                            ServerNetworkHandler.sendToClients(new ClientConnectedPacket(((class_3222)player.get()).method_5667(), playerMuted), ((class_3222)player.get()).method_5667());
                            if (!VoiceServer.getInstance().getConfig().getBoolean("disable_logs")) {
                                VoiceServer.LOGGER.info(String.format("New client: %s", ((class_3222)player.get()).method_7334().getName()));
                            }
                        }
                        SocketServerUDP.sendTo(PacketUDP.write(new AuthPacketAck()), sock);
                    }
                }
                if ((client = SocketServerUDP.getSender(message)) == null || (player = client.getPlayer()) == null) continue;
                if (message.getPacket() instanceof PingPacket) {
                    client.setKeepAlive(System.currentTimeMillis());
                    continue;
                }
                if (VoiceServer.getPlayerManager().isMuted(player.method_5667())) continue;
                clients = message.getPacket();
                if (clients instanceof VoiceClientPacket) {
                    VoiceClientPacket packet3 = (VoiceClientPacket)clients;
                    if (!VoiceServer.getPlayerManager().hasPermission(player.method_5667(), "voice.speak")) continue;
                    if (packet3.getDistance() > VoiceServer.getServerConfig().getMaxDistance()) {
                        if (!VoiceServer.getPlayerManager().hasPermission(player.method_5667(), "voice.priority") || packet3.getDistance() > VoiceServer.getServerConfig().getMaxPriorityDistance()) continue;
                        serverPacket = new VoiceServerPacket(packet3.getData(), player.method_5667(), packet3.getSequenceNumber(), packet3.getDistance());
                        SocketServerUDP.sendToNearbyPlayers(serverPacket, player, packet3.getDistance());
                        continue;
                    }
                    serverPacket = new VoiceServerPacket(packet3.getData(), player.method_5667(), packet3.getSequenceNumber(), packet3.getDistance());
                    SocketServerUDP.sendToNearbyPlayers(serverPacket, player, packet3.getDistance());
                    continue;
                }
                serverPacket = message.getPacket();
                if (!(serverPacket instanceof VoiceEndClientPacket)) continue;
                VoiceEndClientPacket packet4 = (VoiceEndClientPacket)serverPacket;
                serverPacket = new VoiceEndServerPacket(player.method_5667());
                SocketServerUDP.sendToNearbyPlayers(serverPacket, player, packet4.getDistance());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
    }

    private void keepAlive() throws IOException {
        long timestamp = System.currentTimeMillis();
        PingPacket keepAlive = new PingPacket();
        ArrayList<UUID> connectionsToDrop = new ArrayList<UUID>(SocketServerUDP.clients.size());
        for (SocketClientUDP connection : SocketServerUDP.clients.values()) {
            if (timestamp - connection.getKeepAlive() >= 15000L) {
                connectionsToDrop.add(connection.getPlayerUUID());
                continue;
            }
            if (timestamp - connection.getSentKeepAlive() < 1000L) continue;
            connection.setSentKeepAlive(timestamp);
            SocketServerUDP.sendTo(PacketUDP.write(keepAlive), connection);
        }
        for (UUID uuid : connectionsToDrop) {
            class_3222 player = PlayerManager.getByUUID(uuid);
            if (VoiceServer.isLogsEnabled()) {
                VoiceServer.LOGGER.info("{} UDP timed out", (Object)player.method_7334().getName());
                VoiceServer.LOGGER.info("{} sent reconnect packet", (Object)player.method_7334().getName());
            }
            ServerNetworkHandler.reconnectClient(player);
        }
    }

    private static /* synthetic */ void lambda$run$1(List clients, UUID uuid, SocketClientUDP c) {
        clients.add(uuid);
    }

    private static /* synthetic */ void lambda$run$0(AuthPacket packet, AtomicReference player, UUID uuid, UUID t) {
        if (t.toString().equals(packet.getToken())) {
            player.set(VoiceServer.getServer().method_3760().method_14602(uuid));
        }
    }
}

