/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.tcp.ClientConnectPacket;
import su.plo.voice.common.packets.tcp.PacketTCP;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.config.ServerConfigFabric;
import su.plo.voice.server.network.ServerNetworkHandler;
import su.plo.voice.server.socket.SocketServerUDP;

public class ServerNetworkHandlerFabric
extends ServerNetworkHandler {
    private static final class_2960 FML_HANDSHAKE = new class_2960("fml:handshake");
    private final HashMap<UUID, ScheduledFuture<?>> kickTimeouts = new HashMap();
    private final Set<UUID> fabricPlayers = new HashSet<UUID>();

    @Override
    public boolean isVanillaPlayer(class_3222 player) {
        return !this.fabricPlayers.contains(player.method_5667());
    }

    @Override
    public void handleJoin(class_3222 player) {
        super.handleJoin(player);
        ServerConfigFabric config = (ServerConfigFabric)VoiceServer.getServerConfig();
        if (config.isClientModRequired()) {
            Optional<ScheduledFuture<?>> timeout = ServerNetworkHandlerFabric.schedule(() -> {
                if (!SocketServerUDP.clients.containsKey(player.method_5667())) {
                    if (VoiceServer.isLogsEnabled()) {
                        VoiceServer.LOGGER.info("Player {} does not have the mod installed!", (Object)player.method_7334().getName());
                    }
                    VoiceServer.getServer().execute(() -> player.field_13987.method_14367((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessage("mod_missing_kick_message"))));
                }
            }, (long)(config.getClientModCheckTimeout() / 20) * 1000L, TimeUnit.MILLISECONDS);
            timeout.ifPresent(future -> this.kickTimeouts.put(player.method_5667(), (ScheduledFuture<?>)future));
        }
    }

    @Override
    public void handleQuit(class_3222 player) {
        if (this.kickTimeouts.containsKey(player.method_5667())) {
            this.kickTimeouts.get(player.method_5667()).cancel(true);
            this.kickTimeouts.remove(player.method_5667());
        }
        this.fabricPlayers.remove(player.method_5667());
        super.handleQuit(player);
    }

    @Override
    public void handleRegisterChannels(List<class_2960> channels, class_3222 player) {
        if (channels.size() > 0 && !playerToken.containsKey(player.method_5667()) && channels.contains(VoiceServer.PLASMO_VOICE) && !SocketServerUDP.clients.containsKey(player.method_5667())) {
            if (this.kickTimeouts.containsKey(player.method_5667())) {
                this.kickTimeouts.get(player.method_5667()).cancel(true);
                this.kickTimeouts.remove(player.method_5667());
            }
            ServerNetworkHandler.reconnectClient(player);
            if (!channels.contains(FML_HANDSHAKE)) {
                this.fabricPlayers.add(player.method_5667());
            }
        }
    }

    public void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        try {
            byte[] data = new byte[buf.readableBytes()];
            buf.duplicate().readBytes(data);
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            Packet pkt = PacketTCP.read(in);
            if (pkt instanceof ClientConnectPacket) {
                ClientConnectPacket packet = (ClientConnectPacket)pkt;
                this.handle(packet, player);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

