/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.common.packets.tcp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import su.plo.voice.common.packets.Packet;

public class ConfigPacket
implements Packet {
    private int sampleRate;
    private final List<Integer> distances;
    private int defaultDistance;
    private int maxPriorityDistance;
    private int fadeDivisor;
    private int priorityFadeDivisor;
    private boolean disableVoiceActivation;

    public ConfigPacket() {
        this.distances = new ArrayList<Integer>();
    }

    public ConfigPacket(int sampleRate, List<Integer> distances, int defaultDistance, int maxPriorityDistance, boolean disableVoiceActivation, int fadeDivisor, int priorityFadeDivisor) {
        this.sampleRate = sampleRate;
        this.distances = distances;
        this.defaultDistance = defaultDistance;
        this.maxPriorityDistance = maxPriorityDistance;
        this.fadeDivisor = fadeDivisor;
        this.priorityFadeDivisor = priorityFadeDivisor;
        this.disableVoiceActivation = disableVoiceActivation;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public List<Integer> getDistances() {
        return this.distances;
    }

    public int getDefaultDistance() {
        return this.defaultDistance;
    }

    public int getFadeDivisor() {
        return this.fadeDivisor;
    }

    public int getPriorityFadeDivisor() {
        return this.priorityFadeDivisor;
    }

    public int getMaxPriorityDistance() {
        return this.maxPriorityDistance;
    }

    public boolean isDisableVoiceActivation() {
        return this.disableVoiceActivation;
    }

    @Override
    public void write(ByteArrayDataOutput buf) throws IOException {
        buf.writeInt(this.sampleRate);
        buf.writeInt(this.distances.size());
        for (int distance : this.distances) {
            buf.writeInt(distance);
        }
        buf.writeInt(this.defaultDistance);
        buf.writeInt(this.maxPriorityDistance);
        buf.writeInt(this.fadeDivisor);
        buf.writeInt(this.priorityFadeDivisor);
        buf.writeBoolean(this.disableVoiceActivation);
    }

    @Override
    public void read(ByteArrayDataInput buf) throws IOException {
        this.sampleRate = buf.readInt();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.distances.add(buf.readInt());
        }
        this.defaultDistance = buf.readInt();
        this.maxPriorityDistance = buf.readInt();
        this.fadeDivisor = buf.readInt();
        this.priorityFadeDivisor = buf.readInt();
        this.disableVoiceActivation = buf.readBoolean();
    }
}

