/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.common.packets.tcp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import su.plo.voice.common.entities.MutedEntity;
import su.plo.voice.common.packets.Packet;

public class ClientsListPacket
implements Packet {
    private final List<UUID> clients;
    private final List<MutedEntity> muted;

    public ClientsListPacket() {
        this.clients = new ArrayList<UUID>();
        this.muted = new ArrayList<MutedEntity>();
    }

    public ClientsListPacket(List<UUID> clients, List<MutedEntity> muted) {
        this.clients = clients;
        this.muted = muted;
    }

    public List<UUID> getClients() {
        return this.clients;
    }

    public List<MutedEntity> getMuted() {
        return this.muted;
    }

    @Override
    public void write(ByteArrayDataOutput buf) throws IOException {
        buf.writeInt(this.clients.size());
        for (UUID uuid : this.clients) {
            buf.writeUTF(uuid.toString());
        }
        buf.writeInt(this.muted.size());
        for (MutedEntity m : this.muted) {
            buf.writeUTF(m.uuid.toString());
            buf.writeLong(m.to.longValue());
        }
    }

    @Override
    public void read(ByteArrayDataInput buf) throws IOException {
        int i;
        this.clients.clear();
        int length = buf.readInt();
        for (i = 0; i < length; ++i) {
            this.clients.add(UUID.fromString(buf.readUTF()));
        }
        this.muted.clear();
        length = buf.readInt();
        for (i = 0; i < length; ++i) {
            this.muted.add(new MutedEntity(UUID.fromString(buf.readUTF()), buf.readLong()));
        }
    }
}

