/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.lwjgl.system.MemoryUtil;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.sound.openal.AlUtil;
import su.plo.voice.client.sound.openal.CustomSoundEngine;

public class CustomSource {
    private static final int NUM_BUFFERS = 32;
    protected final int pointer;
    private final AtomicBoolean playing = new AtomicBoolean(true);
    private final int format;
    private final LinkedList<Integer> freeBuffers = new LinkedList();
    protected class_243 pos;
    private boolean reverbOnly;
    private long lastEnvCalculated;
    private class_243 lastEnvPos;

    @Nullable
    static CustomSource create() {
        int[] is = new int[1];
        AL10.alGenSources((int[])is);
        return AlUtil.checkErrors("Allocate new source") ? null : new CustomSource(is[0]);
    }

    protected CustomSource(int pointer) {
        this.pointer = pointer;
        int[] buffers = new int[32];
        AL10.alGenBuffers((int[])buffers);
        AlUtil.checkErrors("Creating buffers");
        for (int buffer : buffers) {
            this.freeBuffers.offer(buffer);
        }
        this.format = AlUtil.getFormatId(Recorder.getFormat());
    }

    public int getPointer() {
        return this.pointer;
    }

    public void close() {
        if (this.playing.compareAndSet(true, false)) {
            AL10.alSourceStop((int)this.pointer);
            AlUtil.checkErrors("Stop");
            this.removeProcessedBuffers();
            while (!this.freeBuffers.isEmpty()) {
                AL10.alDeleteBuffers((int)this.freeBuffers.poll());
            }
            AL10.alDeleteSources((int[])new int[]{this.pointer});
            AlUtil.checkErrors("Cleanup");
        }
    }

    public void play() {
        if (this.pos == null) {
            return;
        }
        if (this.reverbOnly && CustomSoundEngine.soundPhysicsReverb != null) {
            if (System.currentTimeMillis() - this.lastEnvCalculated > 1000L || this.lastEnvPos != null && this.lastEnvPos.method_1022(this.pos) > 1.0) {
                CustomSoundEngine.soundPhysicsReverb.invoke(null, this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.pointer);
                this.lastEnvPos = this.pos;
                this.lastEnvCalculated = System.currentTimeMillis();
            }
        } else if (CustomSoundEngine.soundPhysicsPlaySound != null && (System.currentTimeMillis() - this.lastEnvCalculated > 1000L || this.lastEnvPos != null && this.lastEnvPos.method_1022(this.pos) > 1.0)) {
            CustomSoundEngine.soundPhysicsPlaySound.invoke(null, this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.pointer);
            this.lastEnvPos = this.pos;
            this.lastEnvCalculated = System.currentTimeMillis();
        }
        if (this.getSourceState() != 4114) {
            AL10.alSourcePlay((int)this.pointer);
            AlUtil.checkErrors("Custom source play");
        }
    }

    private int getSourceState() {
        return !this.playing.get() ? 4116 : AL10.alGetSourcei((int)this.pointer, (int)4112);
    }

    public void pause() {
        if (this.getSourceState() == 4114) {
            AL10.alSourcePause((int)this.pointer);
        }
    }

    public void resume() {
        if (this.getSourceState() == 4115) {
            AL10.alSourcePlay((int)this.pointer);
        }
    }

    public void stop() {
        if (this.playing.get()) {
            AL10.alSourceStop((int)this.pointer);
            AlUtil.checkErrors("Stop");
        }
    }

    public boolean isStopped() {
        return this.getSourceState() == 4116;
    }

    public void setPosition(class_243 vec3d) {
        this.pos = vec3d;
        AL10.alSourcefv((int)this.pointer, (int)4100, (float[])new float[]{(float)vec3d.field_1352, (float)vec3d.field_1351, (float)vec3d.field_1350});
    }

    public void setDirection(class_243 vec3d) {
        AL10.alSourcefv((int)this.pointer, (int)4101, (float[])new float[]{(float)vec3d.field_1352, (float)vec3d.field_1351, (float)vec3d.field_1350});
    }

    public void setVelocity(class_243 vec3d) {
        AL10.alSourcefv((int)this.pointer, (int)4102, (float[])new float[]{(float)vec3d.field_1352, (float)vec3d.field_1351, (float)vec3d.field_1350});
    }

    public void setAngle(float f) {
        AL10.alSourcef((int)this.pointer, (int)4097, (float)f);
    }

    public void setConeOuterGain(float f) {
        AL10.alSourcef((int)this.pointer, (int)4130, (float)f);
    }

    public void setPitch(float f) {
        AL10.alSourcef((int)this.pointer, (int)4099, (float)f);
    }

    public void setLooping(boolean bl) {
        AL10.alSourcei((int)this.pointer, (int)4103, (int)(bl ? 1 : 0));
    }

    public void setMaxVolume(float f) {
        AL10.alSourcef((int)this.pointer, (int)4110, (float)f);
    }

    public void setVolume(float f) {
        AL10.alSourcef((int)this.pointer, (int)4110, (float)4.0f);
        AL10.alSourcef((int)this.pointer, (int)4106, (float)f);
    }

    public void disableAttenuation() {
        AL10.alSourcei((int)this.pointer, (int)53248, (int)0);
    }

    public void setFadeDistance(float f) {
        AL10.alSourcei((int)this.pointer, (int)53248, (int)53252);
        AL10.alSourcef((int)this.pointer, (int)4128, (float)f);
    }

    public void setMaxDistance(float f, float factor) {
        AL10.alSourcef((int)this.pointer, (int)4131, (float)f);
        AL10.alSourcef((int)this.pointer, (int)4129, (float)factor);
    }

    public void setRelative(boolean bl) {
        AL10.alSourcei((int)this.pointer, (int)514, (int)(bl ? 1 : 0));
    }

    private static int getBufferSize(AudioFormat format, int time) {
        return (int)((float)(time * format.getSampleSizeInBits()) / 8.0f * (float)format.getChannels() * format.getSampleRate());
    }

    public void write(byte[] bytes) {
        if (this.getSourceState() != 4114) {
            AL10.alSourcePlay((int)this.pointer);
            AlUtil.checkErrors("Custom source play");
        }
        this.removeProcessedBuffers();
        this.bufferData(bytes);
        this.play();
    }

    private void bufferData(byte[] bytes) {
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)bytes.length);
        byteBuffer.put(bytes);
        ((Buffer)byteBuffer).flip();
        Integer freeBuffer = this.freeBuffers.poll();
        if (freeBuffer == null) {
            while (freeBuffer == null) {
                this.removeProcessedBuffers();
                freeBuffer = this.freeBuffers.poll();
            }
        }
        AL10.alBufferData((int)freeBuffer, (int)this.format, (ByteBuffer)byteBuffer, (int)((int)Recorder.getFormat().getSampleRate()));
        if (AlUtil.checkErrors("Assigning buffer data to " + freeBuffer + " with format " + this.format + " and rate " + Recorder.getFormat().getSampleRate())) {
            return;
        }
        AL10.alSourceQueueBuffers((int)this.pointer, (int[])new int[]{freeBuffer});
    }

    public void removeProcessedBuffers() {
        for (int i = AL10.alGetSourcei((int)this.pointer, (int)4118); i > 0; --i) {
            int[] is = new int[1];
            AL10.alSourceUnqueueBuffers((int)this.pointer, (int[])is);
            AlUtil.checkErrors("Unqueue buffers");
            this.freeBuffers.offer(is[0]);
        }
    }

    public void setReverbOnly(boolean reverbOnly) {
        this.reverbOnly = reverbOnly;
    }
}

