/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound;

import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.utils.AudioUtils;

public class Limiter {
    private static final float limiterSlope = 1.0f;
    private static final float outputGain = AudioUtils.dbToMul(0.0f);
    private final Float threshold;
    private float[] envelopeBuf = new float[0];
    private float envelope;

    public Limiter(float threshold) {
        this.threshold = Float.valueOf(threshold);
    }

    public Limiter() {
        this.threshold = null;
    }

    public synchronized void limit(float[] audioFloats) {
        this.analyzeEnvelope(audioFloats);
        this.process(audioFloats);
    }

    private synchronized void analyzeEnvelope(float[] samples) {
        this.envelopeBuf = new float[samples.length];
        float attackGain = AudioUtils.gainCoefficient(Recorder.getSampleRate(), 1.0E-6f);
        float releaseGain = AudioUtils.gainCoefficient(Recorder.getSampleRate(), 0.06f);
        float env = this.envelope;
        for (int i = 0; i < samples.length; ++i) {
            float envIn = Math.abs(samples[i]);
            env = env < envIn ? envIn + attackGain * (env - envIn) : envIn + releaseGain * (env - envIn);
            this.envelopeBuf[i] = Math.max(this.envelopeBuf[i], env);
        }
        this.envelope = this.envelopeBuf[samples.length - 1];
    }

    private synchronized void process(float[] samples) {
        float limiterThreshold = this.threshold != null ? this.threshold.floatValue() : (float)((Integer)VoiceClient.getClientConfig().limiterThreshold.get()).intValue();
        int i = 0;
        while (i < samples.length) {
            float envDB = AudioUtils.mulToDB(this.envelopeBuf[i]);
            float limiterGain = 1.0f * (limiterThreshold - envDB);
            limiterGain = AudioUtils.dbToMul(Math.min(0.0f, limiterGain));
            int n = i++;
            samples[n] = samples[n] * (limiterGain * outputGain);
        }
    }
}

