/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.config.ClientConfig;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.render.SphereRenderer;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.client.sound.AbstractSoundQueue;
import su.plo.voice.common.entities.MutedEntity;
import su.plo.voice.common.packets.tcp.ConfigPacket;

public class ServerSettings {
    private String secret;
    private String ip;
    private int port;
    private HashSet<UUID> clients = new HashSet();
    private ConcurrentHashMap<UUID, MutedEntity> muted = new ConcurrentHashMap();
    private List<Integer> distances = new ArrayList<Integer>();
    private short distance;
    private short defaultDistance;
    private short minDistance;
    private short maxDistance;
    private short maxPriorityDistance;
    private short priorityDistance;
    private int fadeDivisor;
    private int priorityFadeDivisor;
    private boolean priority;
    private boolean voiceActivationDisabled;

    public ServerSettings(String secret, String ip, int port, boolean hasPriority) {
        this.secret = secret;
        this.ip = ip;
        this.port = port;
        this.priority = hasPriority;
    }

    public void update(ConfigPacket config) {
        short oldDistance = this.distance;
        this.distances = config.getDistances();
        Collections.sort(this.distances);
        this.minDistance = this.distances.get(0).shortValue();
        this.maxDistance = this.distances.get(this.distances.size() - 1).shortValue();
        this.maxPriorityDistance = (short)config.getMaxPriorityDistance();
        this.maxPriorityDistance = (short)(this.maxPriorityDistance == 0 ? Short.MAX_VALUE : (int)this.maxPriorityDistance);
        this.fadeDivisor = config.getFadeDivisor();
        this.priorityFadeDivisor = config.getPriorityFadeDivisor();
        this.voiceActivationDisabled = config.isDisableVoiceActivation();
        this.defaultDistance = (short)config.getDefaultDistance();
        if (VoiceClient.getClientConfig().getServers().containsKey(this.ip)) {
            ClientConfig.ServerConfig serverConfig = VoiceClient.getClientConfig().getServers().get(this.ip);
            serverConfig.distance.setDefault(Integer.valueOf(this.defaultDistance));
            serverConfig.priorityDistance.setDefault(Math.min(this.maxPriorityDistance, this.maxDistance * 2));
            if (this.distances.contains(serverConfig.distance.get())) {
                this.distance = ((Integer)serverConfig.distance.get()).shortValue();
            } else {
                this.distance = (short)config.getDefaultDistance();
                serverConfig.distance.set(Integer.valueOf(this.distance));
            }
            if ((Integer)serverConfig.priorityDistance.get() > this.maxDistance && (Integer)serverConfig.priorityDistance.get() < this.maxPriorityDistance) {
                this.priorityDistance = ((Integer)serverConfig.priorityDistance.get()).shortValue();
            } else {
                this.priorityDistance = (short)Math.min(this.maxPriorityDistance, this.maxDistance * 2);
                serverConfig.priorityDistance.set(Integer.valueOf(this.priorityDistance));
            }
        } else {
            this.distance = (short)config.getDefaultDistance();
            this.priorityDistance = (short)Math.min(this.maxPriorityDistance, this.maxDistance * 2);
            ClientConfig.ServerConfig serverConfig = new ClientConfig.ServerConfig();
            serverConfig.distance.setDefault(config.getDefaultDistance());
            serverConfig.priorityDistance.setDefault(Math.min(this.maxPriorityDistance, this.maxDistance * 2));
            VoiceClient.getClientConfig().getServers().put(this.ip, serverConfig);
        }
        VoiceClient.setSpeaking(false);
        VoiceClient.setSpeakingPriority(false);
        VoiceClient.recorder.updateSampleRate(config.getSampleRate());
        SocketClientUDPQueue.talking.clear();
        SocketClientUDPQueue.audioChannels.values().forEach(AbstractSoundQueue::closeAndKill);
        SocketClientUDPQueue.audioChannels.clear();
        if (VoiceClient.isSettingsOpen()) {
            ((VoiceSettingsScreen)class_310.method_1551().field_1755).updateGeneralTab();
        }
        SphereRenderer.getInstance().setRadius((float)this.distance + 0.5f, this.distance != oldDistance && oldDistance > 0, false);
    }

    public void setDistance(short distance) {
        this.distance = distance;
        SphereRenderer.getInstance().setRadius((float)this.distance + 0.5f, false);
    }

    public void setPriorityDistance(short distance) {
        this.priorityDistance = distance;
        SphereRenderer.getInstance().setRadius((float)this.priorityDistance + 0.5f, true);
    }

    public String getSecret() {
        return this.secret;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public HashSet<UUID> getClients() {
        return this.clients;
    }

    public ConcurrentHashMap<UUID, MutedEntity> getMuted() {
        return this.muted;
    }

    public List<Integer> getDistances() {
        return this.distances;
    }

    public short getDistance() {
        return this.distance;
    }

    public short getDefaultDistance() {
        return this.defaultDistance;
    }

    public short getMinDistance() {
        return this.minDistance;
    }

    public short getMaxDistance() {
        return this.maxDistance;
    }

    public short getMaxPriorityDistance() {
        return this.maxPriorityDistance;
    }

    public short getPriorityDistance() {
        return this.priorityDistance;
    }

    public int getFadeDivisor() {
        return this.fadeDivisor;
    }

    public int getPriorityFadeDivisor() {
        return this.priorityFadeDivisor;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public boolean isVoiceActivationDisabled() {
        return this.voiceActivationDisabled;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDefaultDistance(short defaultDistance) {
        this.defaultDistance = defaultDistance;
    }

    public void setMinDistance(short minDistance) {
        this.minDistance = minDistance;
    }

    public void setMaxDistance(short maxDistance) {
        this.maxDistance = maxDistance;
    }

    public void setMaxPriorityDistance(short maxPriorityDistance) {
        this.maxPriorityDistance = maxPriorityDistance;
    }

    public void setFadeDivisor(int fadeDivisor) {
        this.fadeDivisor = fadeDivisor;
    }

    public void setPriorityFadeDivisor(int priorityFadeDivisor) {
        this.priorityFadeDivisor = priorityFadeDivisor;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public void setVoiceActivationDisabled(boolean voiceActivationDisabled) {
        this.voiceActivationDisabled = voiceActivationDisabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerSettings)) {
            return false;
        }
        ServerSettings other = (ServerSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getDistance() != other.getDistance()) {
            return false;
        }
        if (this.getDefaultDistance() != other.getDefaultDistance()) {
            return false;
        }
        if (this.getMinDistance() != other.getMinDistance()) {
            return false;
        }
        if (this.getMaxDistance() != other.getMaxDistance()) {
            return false;
        }
        if (this.getMaxPriorityDistance() != other.getMaxPriorityDistance()) {
            return false;
        }
        if (this.getPriorityDistance() != other.getPriorityDistance()) {
            return false;
        }
        if (this.getFadeDivisor() != other.getFadeDivisor()) {
            return false;
        }
        if (this.getPriorityFadeDivisor() != other.getPriorityFadeDivisor()) {
            return false;
        }
        if (this.isPriority() != other.isPriority()) {
            return false;
        }
        if (this.isVoiceActivationDisabled() != other.isVoiceActivationDisabled()) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        HashSet<UUID> this$clients = this.getClients();
        HashSet<UUID> other$clients = other.getClients();
        if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
            return false;
        }
        ConcurrentHashMap<UUID, MutedEntity> this$muted = this.getMuted();
        ConcurrentHashMap<UUID, MutedEntity> other$muted = other.getMuted();
        if (this$muted == null ? other$muted != null : !((Object)this$muted).equals(other$muted)) {
            return false;
        }
        List<Integer> this$distances = this.getDistances();
        List<Integer> other$distances = other.getDistances();
        return !(this$distances == null ? other$distances != null : !((Object)this$distances).equals(other$distances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getDistance();
        result = result * 59 + this.getDefaultDistance();
        result = result * 59 + this.getMinDistance();
        result = result * 59 + this.getMaxDistance();
        result = result * 59 + this.getMaxPriorityDistance();
        result = result * 59 + this.getPriorityDistance();
        result = result * 59 + this.getFadeDivisor();
        result = result * 59 + this.getPriorityFadeDivisor();
        result = result * 59 + (this.isPriority() ? 79 : 97);
        result = result * 59 + (this.isVoiceActivationDisabled() ? 79 : 97);
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        HashSet<UUID> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        ConcurrentHashMap<UUID, MutedEntity> $muted = this.getMuted();
        result = result * 59 + ($muted == null ? 43 : ((Object)$muted).hashCode());
        List<Integer> $distances = this.getDistances();
        result = result * 59 + ($distances == null ? 43 : ((Object)$distances).hashCode());
        return result;
    }

    public String toString() {
        return "ServerSettings(secret=" + this.getSecret() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", clients=" + this.getClients() + ", muted=" + this.getMuted() + ", distances=" + this.getDistances() + ", distance=" + this.getDistance() + ", defaultDistance=" + this.getDefaultDistance() + ", minDistance=" + this.getMinDistance() + ", maxDistance=" + this.getMaxDistance() + ", maxPriorityDistance=" + this.getMaxPriorityDistance() + ", priorityDistance=" + this.getPriorityDistance() + ", fadeDivisor=" + this.getFadeDivisor() + ", priorityFadeDivisor=" + this.getPriorityFadeDivisor() + ", priority=" + this.isPriority() + ", voiceActivationDisabled=" + this.isVoiceActivationDisabled() + ")";
    }

    private void setClients(HashSet<UUID> clients) {
        this.clients = clients;
    }

    private void setMuted(ConcurrentHashMap<UUID, MutedEntity> muted) {
        this.muted = muted;
    }

    private void setDistances(List<Integer> distances) {
        this.distances = distances;
    }
}

