/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.UUID;

public class DataEntity {
    private static final Gson gson = new Gson();
    public final HashSet<UUID> mutedClients;
    public final HashSet<UUID> whitelisted;

    public static DataEntity read() {
        File dataFile = new File("config/PlasmoVoice/data.json");
        if (dataFile.exists()) {
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(dataFile));
                try {
                    return (DataEntity)gson.fromJson(reader, DataEntity.class);
                }
                catch (JsonSyntaxException j) {
                    dataFile.delete();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return new DataEntity(new HashSet<UUID>(), new HashSet<UUID>());
    }

    public void save() {
        File configDir = new File("config/PlasmoVoice");
        configDir.mkdirs();
        try (FileWriter w = new FileWriter("config/PlasmoVoice/data.json");){
            w.write(gson.toJson((Object)this));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DataEntity(HashSet<UUID> mutedClients, HashSet<UUID> whitelisted) {
        this.mutedClients = mutedClients;
        this.whitelisted = whitelisted;
    }
}

