/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.optifine.shaders.config.ShaderOption;

public class ShaderProfile {
    private String name = null;
    private Map<String, String> mapOptionValues = new LinkedHashMap();
    private Set<String> disabledPrograms = new LinkedHashSet();

    public ShaderProfile(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addOptionValue(String option, String value) {
        this.mapOptionValues.put(option, value);
    }

    public void addOptionValues(ShaderProfile prof) {
        if (prof == null) {
            return;
        }
        this.mapOptionValues.putAll(prof.mapOptionValues);
    }

    public void applyOptionValues(ShaderOption[] options) {
        for (int i2 = 0; i2 < options.length; ++i2) {
            ShaderOption so = options[i2];
            String key = so.getName();
            String val = (String)this.mapOptionValues.get(key);
            if (val == null) continue;
            so.setValue(val);
        }
    }

    public String[] getOptions() {
        Set keys = this.mapOptionValues.keySet();
        String[] opts = keys.toArray(new String[keys.size()]);
        return opts;
    }

    public String getValue(String key) {
        return (String)this.mapOptionValues.get(key);
    }

    public void addDisabledProgram(String program) {
        this.disabledPrograms.add(program);
    }

    public void removeDisabledProgram(String program) {
        this.disabledPrograms.remove(program);
    }

    public Collection<String> getDisabledPrograms() {
        return new LinkedHashSet<String>(this.disabledPrograms);
    }

    public void addDisabledPrograms(Collection<String> programs) {
        this.disabledPrograms.addAll(programs);
    }

    public boolean isProgramDisabled(String program) {
        return this.disabledPrograms.contains(program);
    }
}

