/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.modmuss50.optifabric.patcher.Lambda;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

class MethodComparison {
    public final MethodNode node;
    public final boolean equal;
    public final boolean effectivelyEqual;
    private final List<Lambda> originalLambdas = new ArrayList<Lambda>();
    private final List<Lambda> patchedLambdas = new ArrayList<Lambda>();

    public MethodComparison(MethodNode original, MethodNode patched) {
        this(original, patched, false);
    }

    MethodComparison(MethodNode original, MethodNode patched, boolean permissive) {
        assert (Objects.equals(original.name, patched.name) || permissive);
        assert (Objects.equals(original.desc, patched.desc) || permissive);
        this.node = patched;
        this.effectivelyEqual = this.compare(original.instructions, patched.instructions);
        this.equal = this.effectivelyEqual && this.originalLambdas.equals(this.patchedLambdas);
    }

    private static int nextInterestingNode(InsnList list, int start) {
        AbstractInsnNode node;
        do {
            if (start < list.size()) continue;
            return -1;
        } while ((node = list.get(start++)).getType() == 15 || node.getType() == 14);
        return start - 1;
    }

    private boolean compare(InsnList listA, InsnList listB) {
        int a = MethodComparison.nextInterestingNode(listA, 0);
        int b = MethodComparison.nextInterestingNode(listB, 0);
        while (a >= 0 && b >= 0) {
            AbstractInsnNode insnB;
            AbstractInsnNode insnA = listA.get(a);
            if (!this.compare(listA, listB, insnA, insnB = listB.get(b))) {
                MethodComparison.findHandles(listA, a, this::logOriginalLambda);
                MethodComparison.findHandles(listB, b, this::logPatchedLambda);
                return false;
            }
            a = MethodComparison.nextInterestingNode(listA, a + 1);
            b = MethodComparison.nextInterestingNode(listB, b + 1);
        }
        return a == b;
    }

    private boolean compare(InsnList listA, InsnList listB, AbstractInsnNode insnA, AbstractInsnNode insnB) {
        if (insnA.getType() != insnB.getType() || insnA.getOpcode() != insnB.getOpcode()) {
            return false;
        }
        switch (insnA.getType()) {
            case 1: {
                IntInsnNode a = (IntInsnNode)insnA;
                IntInsnNode b = (IntInsnNode)insnB;
                return a.operand == b.operand;
            }
            case 2: {
                VarInsnNode a = (VarInsnNode)insnA;
                VarInsnNode b = (VarInsnNode)insnB;
                return a.var == b.var;
            }
            case 3: {
                TypeInsnNode a = (TypeInsnNode)insnA;
                TypeInsnNode b = (TypeInsnNode)insnB;
                return Objects.equals(a.desc, b.desc);
            }
            case 4: {
                FieldInsnNode a = (FieldInsnNode)insnA;
                FieldInsnNode b = (FieldInsnNode)insnB;
                return Objects.equals(a.owner, b.owner) && Objects.equals(a.name, b.name) && Objects.equals(a.desc, b.desc);
            }
            case 5: {
                MethodInsnNode a = (MethodInsnNode)insnA;
                MethodInsnNode b = (MethodInsnNode)insnB;
                if (!(Objects.equals(a.owner, b.owner) && Objects.equals(a.name, b.name) && Objects.equals(a.desc, b.desc))) {
                    return false;
                }
                return a.itf == b.itf;
            }
            case 6: {
                InvokeDynamicInsnNode a = (InvokeDynamicInsnNode)insnA;
                InvokeDynamicInsnNode b = (InvokeDynamicInsnNode)insnB;
                if (!a.bsm.equals((Object)b.bsm)) {
                    return false;
                }
                if (MethodComparison.isJavaLambdaMetafactory(a.bsm)) {
                    Handle implA = (Handle)a.bsmArgs[1];
                    Handle implB = (Handle)b.bsmArgs[1];
                    if (implA.getTag() != implB.getTag()) {
                        return false;
                    }
                    switch (implA.getTag()) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            this.logOriginalLambda(a, implA);
                            this.logPatchedLambda(b, implB);
                            return true;
                        }
                    }
                    throw new IllegalStateException("Unexpected impl tag: " + implA.getTag());
                }
                if ("java/lang/invoke/StringConcatFactory".equals(a.bsm.getOwner())) {
                    return true;
                }
                if ("java/lang/runtime/ObjectMethods".equals(a.bsm.getOwner())) {
                    return Objects.equals(a.name, b.name) && Arrays.asList(a.bsmArgs).subList(2, a.bsmArgs.length).equals(Arrays.asList(b.bsmArgs).subList(2, b.bsmArgs.length));
                }
                throw new IllegalStateException(String.format("Unknown invokedynamic bsm: %s#%s%s (tag=%d iif=%b)", a.bsm.getOwner(), a.bsm.getName(), a.bsm.getDesc(), a.bsm.getTag(), a.bsm.isInterface()));
            }
            case 7: {
                JumpInsnNode a = (JumpInsnNode)insnA;
                JumpInsnNode b = (JumpInsnNode)insnB;
                return Integer.signum(listA.indexOf((AbstractInsnNode)a.label) - listA.indexOf((AbstractInsnNode)a)) == Integer.signum(listB.indexOf((AbstractInsnNode)b.label) - listB.indexOf((AbstractInsnNode)b));
            }
            case 9: {
                LdcInsnNode a = (LdcInsnNode)insnA;
                LdcInsnNode b = (LdcInsnNode)insnB;
                Class<?> typeClsA = a.cst.getClass();
                if (typeClsA != b.cst.getClass()) {
                    return false;
                }
                if (typeClsA == Type.class) {
                    Type typeA = (Type)a.cst;
                    Type typeB = (Type)b.cst;
                    if (typeA.getSort() != typeB.getSort()) {
                        return false;
                    }
                    switch (typeA.getSort()) {
                        case 9: 
                        case 10: {
                            return Objects.equals(typeA.getDescriptor(), typeB.getDescriptor());
                        }
                        case 11: {
                            throw new UnsupportedOperationException("Bad sort: " + typeA);
                        }
                    }
                } else {
                    return a.cst.equals(b.cst);
                }
            }
            case 10: {
                LdcInsnNode a = (IincInsnNode)insnA;
                LdcInsnNode b = (IincInsnNode)insnB;
                return a.incr == b.incr && a.var == b.var;
            }
            case 11: {
                TableSwitchInsnNode a = (TableSwitchInsnNode)insnA;
                TableSwitchInsnNode b = (TableSwitchInsnNode)insnB;
                return a.min == b.min && a.max == b.max;
            }
            case 12: {
                LookupSwitchInsnNode a = (LookupSwitchInsnNode)insnA;
                LookupSwitchInsnNode b = (LookupSwitchInsnNode)insnB;
                return a.keys.equals(b.keys);
            }
            case 13: {
                MultiANewArrayInsnNode a = (MultiANewArrayInsnNode)insnA;
                MultiANewArrayInsnNode b = (MultiANewArrayInsnNode)insnB;
                return a.dims == b.dims && Objects.equals(a.desc, b.desc);
            }
            case 0: 
            case 8: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected instructions: " + insnA + ", " + insnB);
    }

    static boolean isJavaLambdaMetafactory(Handle bsm) {
        return bsm.getTag() == 6 && "java/lang/invoke/LambdaMetafactory".equals(bsm.getOwner()) && ("metafactory".equals(bsm.getName()) && "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;".equals(bsm.getDesc()) || "altMetafactory".equals(bsm.getName()) && "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;".equals(bsm.getDesc())) && !bsm.isInterface();
    }

    private static void findHandles(InsnList instructions, int from, BiConsumer<InvokeDynamicInsnNode, Handle> lambdaEater) {
        MethodComparison.findLambdas(instructions, from, idin -> {
            Handle impl = (Handle)idin.bsmArgs[1];
            switch (impl.getTag()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    lambdaEater.accept((InvokeDynamicInsnNode)idin, impl);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected impl tag: " + impl.getTag());
                }
            }
        });
    }

    private static void findLambdas(InsnList instructions, int from, Consumer<InvokeDynamicInsnNode> instructionEater) {
        while (from < instructions.size()) {
            AbstractInsnNode insn = instructions.get(from);
            if (insn.getType() == 6) {
                InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)insn;
                if (MethodComparison.isJavaLambdaMetafactory(idin.bsm)) {
                    instructionEater.accept(idin);
                } else if (!"java/lang/invoke/StringConcatFactory".equals(idin.bsm.getOwner()) && !"java/lang/runtime/ObjectMethods".equals(idin.bsm.getOwner())) {
                    throw new IllegalStateException(String.format("Unknown invokedynamic bsm: %s#%s%s (tag=%d iif=%b)", idin.bsm.getOwner(), idin.bsm.getName(), idin.bsm.getDesc(), idin.bsm.getTag(), idin.bsm.isInterface()));
                }
            }
            ++from;
        }
    }

    private void logOriginalLambda(InvokeDynamicInsnNode node, Handle handle) {
        this.originalLambdas.add(new Lambda(handle.getOwner(), handle.getName(), handle.getDesc(), node.name.concat(node.desc)));
    }

    private void logPatchedLambda(InvokeDynamicInsnNode node, Handle handle) {
        this.patchedLambdas.add(new Lambda(handle.getOwner(), handle.getName(), handle.getDesc(), node.name.concat(node.desc)));
    }

    public boolean hasLambdas() {
        return !this.originalLambdas.isEmpty() && !this.patchedLambdas.isEmpty();
    }

    public List<Lambda> getOriginalLambads() {
        return Collections.unmodifiableList(this.originalLambdas);
    }

    public List<Lambda> getPatchedLambads() {
        return Collections.unmodifiableList(this.patchedLambdas);
    }

    public String toString() {
        return this.node.name.concat(this.node.desc);
    }
}

