/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.screen.ingame;

import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.screen.IScreen;
import io.github.kosmx.emotes.executor.dataTypes.screen.widgets.ITextInputWidget;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.screen.AbstractScreenLogic;
import io.github.kosmx.emotes.main.screen.IScreenSlave;
import io.github.kosmx.emotes.main.screen.widget.IEmoteListWidgetHelper;

public abstract class FullMenuScreenHelper<MATRIX, SCREEN, WIDGET>
extends AbstractScreenLogic<MATRIX, SCREEN> {
    private ITextInputWidget<MATRIX, ITextInputWidget> searchBox;
    private IEmoteListWidgetHelper<MATRIX, WIDGET> emoteList;

    protected FullMenuScreenHelper(IScreenSlave screen) {
        super(screen);
    }

    public abstract IScreen<SCREEN> newEmoteMenu();

    @Override
    public void emotes_initScreen() {
        int x = (int)Math.min((double)this.screen.getWidth() * 0.8, (double)(this.screen.getHeight() - 60));
        this.searchBox = this.newTextInputWidget((this.screen.getWidth() - x) / 2, 12, x, 20, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.search"));
        this.searchBox.setInputListener(string -> this.emoteList.filter(string::toLowerCase));
        this.emoteList = this.newEmoteList(x, this.screen.getHeight(), this.screen.getWidth());
        this.emoteList.emotesSetLeftPos((this.screen.getWidth() - x) / 2);
        this.emoteList.setEmotes((Iterable<EmoteHolder>)EmoteHolder.list, false);
        this.screen.addToChildren(this.searchBox);
        this.screen.addToChildren(this.emoteList);
        this.screen.setInitialFocus(this.searchBox);
        this.screen.addToButtons(this.newButton(this.screen.getWidth() - 120, this.screen.getHeight() - 30, 96, 20, EmoteInstance.instance.getDefaults().defaultTextCancel(), button -> this.screen.openScreen(null)));
        this.screen.addToButtons(this.newButton(this.screen.getWidth() - 120, this.screen.getHeight() - 60, 96, 20, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.config"), button -> this.screen.openScreen(this.newEmoteMenu())));
        this.screen.addButtonsToChildren();
    }

    protected IEmoteListWidgetHelper<MATRIX, WIDGET> newEmoteList(int boxSize, int height, int width) {
        return this.newEmoteList(boxSize, height, (height - boxSize) / 2 + 10, width > (width + boxSize) / 2 + 120 ? (height + boxSize) / 2 + 10 : height - 80, 36);
    }

    protected abstract IEmoteListWidgetHelper<MATRIX, WIDGET> newEmoteList(int var1, int var2, int var3, int var4, int var5);

    @Override
    public boolean emotes_isThisPauseScreen() {
        return false;
    }

    @Override
    public void emotes_renderScreen(MATRIX matrices, int mouseX, int mouseY, float delta) {
        this.screen.emotesRenderBackgroundTexture(0);
        this.emoteList.renderThis(matrices, mouseX, mouseY, delta);
        this.searchBox.render(matrices, mouseX, mouseY, delta);
    }
}

