/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class DiscoveryPacket
extends AbstractNetworkPacket {
    @Override
    public boolean read(ByteBuffer buf, NetData data, int version) {
        int size = buf.getInt();
        HashMap<Byte, Byte> map = new HashMap<Byte, Byte>();
        for (int i = 0; i < size; ++i) {
            byte id = buf.get();
            byte ver = buf.get();
            map.put(id, ver);
        }
        data.versions = map;
        data.versionsUpdated = true;
        return true;
    }

    @Override
    public void write(ByteBuffer buf, NetData data) {
        buf.putInt(data.versions.size());
        data.versions.forEach((aByte, integer) -> {
            buf.put((byte)aByte);
            buf.put((byte)integer);
        });
    }

    @Override
    public byte getID() {
        return 8;
    }

    @Override
    public byte getVer() {
        return 8;
    }

    @Override
    public boolean doWrite(NetData config) {
        return config.purpose == PacketTask.CONFIG;
    }

    @Override
    public int calculateSize(NetData config) {
        return config.versions.size() * 2 + 4;
    }
}

