/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.donor;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageLoader {
    private static final Cleaner cleaner = Cleaner.create();

    public static ImageFrame[] readGif(InputStream stream) throws IOException {
        ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(2);
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        reader.setInput(ImageIO.createImageInputStream(stream));
        int lastx = 0;
        int lasty = 0;
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        Color backgroundColor = null;
        if (metadata != null) {
            IIOMetadataNode colorTable;
            IIOMetadataNode screenDescriptor;
            IIOMetadataNode globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
            NodeList globalColorTable = globalRoot.getElementsByTagName("GlobalColorTable");
            NodeList globalScreeDescriptor = globalRoot.getElementsByTagName("LogicalScreenDescriptor");
            if (globalScreeDescriptor != null && globalScreeDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreeDescriptor.item(0)) != null) {
                width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
                height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
            }
            if (globalColorTable != null && globalColorTable.getLength() > 0 && (colorTable = (IIOMetadataNode)globalColorTable.item(0)) != null) {
                String bgIndex = colorTable.getAttribute("backgroundColorIndex");
                for (IIOMetadataNode colorEntry = (IIOMetadataNode)colorTable.getFirstChild(); colorEntry != null; colorEntry = (IIOMetadataNode)colorEntry.getNextSibling()) {
                    if (!colorEntry.getAttribute("index").equals(bgIndex)) continue;
                    int red = Integer.parseInt(colorEntry.getAttribute("red"));
                    int green = Integer.parseInt(colorEntry.getAttribute("green"));
                    int blue = Integer.parseInt(colorEntry.getAttribute("blue"));
                    int alpha = 0;
                    backgroundColor = new Color(red, green, blue, alpha);
                    break;
                }
            }
        }
        BufferedImage master = null;
        boolean hasBackround = false;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            NodeList children = root.getChildNodes();
            int delay = Integer.valueOf(gce.getAttribute("delayTime"));
            String disposal = gce.getAttribute("disposalMethod");
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                Graphics2D gr = master.createGraphics();
                gr.setColor(backgroundColor);
                gr.setComposite(AlphaComposite.Clear);
                gr.fillRect(0, 0, master.getWidth(), master.getHeight());
                hasBackround = image.getWidth() == width && image.getHeight() == height;
                master.createGraphics().drawImage((Image)image, 0, 0, null);
            } else {
                int x = 0;
                int y = 0;
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.valueOf(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.valueOf(map.getNamedItem("imageTopPosition").getNodeValue());
                }
                if (disposal.equals("restoreToPrevious")) {
                    BufferedImage from = null;
                    for (int i = frameIndex - 1; i >= 0; --i) {
                        if (((ImageFrame)frames.get(i)).getDisposal().equals("restoreToPrevious") && frameIndex != 0) continue;
                        from = ((ImageFrame)frames.get(i)).getImage();
                        break;
                    }
                    ColorModel model = from.getColorModel();
                    boolean alpha = from.isAlphaPremultiplied();
                    WritableRaster raster = from.copyData(null);
                    master = new BufferedImage(model, raster, alpha, null);
                } else if (disposal.equals("restoreToBackgroundColor") && backgroundColor != null && (!hasBackround || frameIndex > 1)) {
                    Graphics2D gr = master.createGraphics();
                    gr.setColor(backgroundColor);
                    gr.setComposite(AlphaComposite.Clear);
                    gr.fillRect(lastx, lasty, ((ImageFrame)frames.get(frameIndex - 1)).getWidth(), ((ImageFrame)frames.get(frameIndex - 1)).getHeight());
                }
                master.createGraphics().drawImage((Image)image, x, y, null);
                lastx = x;
                lasty = y;
            }
            ColorModel model = master.getColorModel();
            boolean alpha = master.isAlphaPremultiplied();
            WritableRaster raster = master.copyData(null);
            BufferedImage copy = new BufferedImage(model, raster, alpha, null);
            frames.add(new ImageFrame(copy, delay, disposal, image.getWidth(), image.getHeight()));
            master.flush();
            ++frameIndex;
        }
        reader.dispose();
        return frames.toArray(new ImageFrame[frames.size()]);
    }

    public static class ImageFrame {
        private final int delay;
        private final BufferedImage image;
        private final String disposal;
        private final int width;
        private final int height;
        private class_1011 nativeImage;
        private class_2960 resource;

        public ImageFrame(BufferedImage image, int delay, String disposal, int width, int height) {
            this.image = image;
            this.delay = delay;
            this.disposal = disposal;
            this.width = width;
            this.height = height;
            this.prepareNativeImage();
        }

        private void prepareNativeImage() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.image, "png", buffer);
                this.nativeImage = class_1011.method_4310((class_1011.class_1012)class_1011.class_1012.field_4997, (InputStream)new ByteArrayInputStream(buffer.toByteArray()));
                class_1043 dyn = new class_1043(class_1011.method_4310((class_1011.class_1012)class_1011.class_1012.field_4997, (InputStream)new ByteArrayInputStream(buffer.toByteArray())));
                RenderSystem.recordRenderCall(() -> {
                    this.resource = class_310.method_1551().method_1531().method_4617("" + this.image.hashCode(), dyn);
                });
                cleaner.register(this, new State(this.nativeImage, this.resource));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public class_1011 getNativeImage() {
            return this.nativeImage;
        }

        public class_2960 getResource() {
            return this.resource;
        }

        public int getDelay() {
            return this.delay;
        }

        public String getDisposal() {
            return this.disposal;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    private static class State
    implements Runnable {
        private class_1011 nativeImage;
        private class_2960 resource;

        State(class_1011 nativeImage, class_2960 resource) {
            this.nativeImage = nativeImage;
            this.resource = resource;
        }

        @Override
        public void run() {
            this.nativeImage.close();
            class_310.method_1551().method_1531().method_4615(this.resource);
        }
    }
}

