/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.configbuilder.PropertyConfig;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerVolumeConfig
extends PropertyConfig {
    private final Map<UUID, Double> volumes;
    private final Map<String, Double> categoryVolumes;

    public PlayerVolumeConfig(Path path) {
        super(path);
        Map<String, Object> entries = this.getEntries();
        this.volumes = new HashMap<UUID, Double>();
        this.categoryVolumes = new HashMap<String, Double>();
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            double volume = Double.parseDouble(entry.getValue().toString());
            try {
                this.volumes.put(UUID.fromString(entry.getKey()), volume);
            }
            catch (IllegalArgumentException e) {
                this.categoryVolumes.put(entry.getKey(), volume);
            }
        }
    }

    public double getPlayerVolume(UUID uuid, double def) {
        Double volume = this.volumes.get(uuid);
        if (volume == null) {
            return def;
        }
        return volume;
    }

    public double getPlayerVolume(UUID playerID) {
        return this.getPlayerVolume(playerID, 1.0);
    }

    public double setPlayerVolume(UUID uuid, double value) {
        this.volumes.put(uuid, value);
        this.properties.put(uuid.toString(), String.valueOf(value));
        return value;
    }

    public Map<UUID, Double> getPlayerVolumes() {
        return Collections.unmodifiableMap(this.volumes);
    }

    public double getCategoryVolume(String category, double def) {
        Double volume = this.categoryVolumes.get(category);
        if (volume == null) {
            return def;
        }
        return volume;
    }

    public double getCategoryVolume(String category) {
        return this.getCategoryVolume(category, 1.0);
    }

    public double setCategoryVolume(String category, double value) {
        this.categoryVolumes.put(category, value);
        this.properties.put(category, String.valueOf(value));
        return value;
    }
}

